//
// Quick-and-dirty code to do popup dialogs like menus, text boxes etc.
//
// Copyright (C) 2009 Toby Murray
// Released under the terms of the GNU GPL version 2
//
var popups = function (createElement, createTextNode, highlightColor) {
    var activePopup = null;
    function destroyActive() {
        if (null !== activePopup) {
            activePopup();
            activePopup = null;
        }
    }
    
    function makePopup(parent, left, top) {
        var popup = createElement('div'), closeButton = createElement('img'); 
        destroyActive();
        activePopup = function () {
            parent.removeChild(popup);
        };
        popup.style.position = 'absolute';
        popup.style.zIndex = 1;
        popup.style.top = top;
        popup.style.left = left;
        popup.style.backgroundColor = '#e5e5e5';
        popup.style.borderBottom = '1px solid #444444';
        popup.style.borderRight = '1px solid #444444';
        popup.style.borderLeft = '1px solid #f0f0f0';
        popup.style.borderTop = '1px solid #f0f0f0';
        popup.style.textAlign = 'left';
        popup.style.color = 'black';
        closeButton.src = 'closebutton.png';
        closeButton.onclick = destroyActive;
        closeButton.align = 'right';
        popup.appendChild(closeButton);
        parent.appendChild(popup);
        return popup;
    }
    return {
        destroyActive: destroyActive,
        makePopupMenu: function (parent, actions, left, top) {
            var aindex, 
            menu = makePopup(parent, left, top);
            function addMenuItem(menuitem) {
                var item = createElement('div'), 
                text = menuitem[0], cb = menuitem[1];
                function mouseOver() {
                    item.style.backgroundColor = highlightColor;
                }
                function mouseOut() {
                    item.style.backgroundColor = 'transparent';
                }
                function destroyAndCb() {
                    destroyActive();
                    cb(text);
                }
                item.style.padding = '3px';
                item.style.backgroundColor = 'transparent';
                item.style.paddingLeft = '5px';
                item.style.paddingRight = '25px';

                item.appendChild(createTextNode(text));
                item.onmouseover = mouseOver;
                item.onmouseout = mouseOut;
                item.onclick = destroyAndCb;
                menu.appendChild(item);
            }
            for (aindex = 0; aindex < actions.length; aindex += 1) {
                addMenuItem(actions[aindex]);
            }
            
        },
        makePopupContaining: function (parent, contents, left, top) {
            var popup = makePopup(parent, left, top);
            popup.appendChild(contents);
        },


        makePopupTextbox: function (parent, onCommit, left, top) {
            var popup = makePopup(parent, left, top),
            formbox = createElement('form'),
            textbox = createElement('input');
            formbox.action = '#';
            formbox.padding = '0px';
            textbox.type = 'text';
            formbox.appendChild(textbox);
            formbox.onsubmit = function () {
                destroyActive();
                onCommit(textbox.value);
            }
            popup.appendChild(formbox);
        }
    };
};
