//
// Quick-and-dirty code to do treeview-like widgets
//
// Copyright (C) 2009 Toby Murray
// Released under the terms of the GNU GPL version 2
//
var treeview = function (createElement, createTextNode, highlightColor) {
    var emptyRow  = createElement('tr'),
    emptyCell = createElement('td'),
    emptyContent = createElement('i');
    emptyContent.appendChild(createTextNode('(empty)'));
    emptyCell.appendChild(emptyContent);
    emptyRow.appendChild(emptyCell);

    function make(rootitems) {
        var item, itemidx, table, tr, expandCell, expand, numChildren = 0,
            element, eidx, ecell, contentCell, contentRow, contentTable,
            clickable;

        function makeNodeObj(parent, clickable, expand, getchildrencb, 
                             opencb, closecb, clickcb, mousedowncb, mouseupcb,
                             mouseovercb, mouseoutcb, setrefreshcb) {
            var isOpened = false, stateUnknown = false, nodeObj, 
                childWidget;
            function open() {
                var p = getchildrencb();
                p.when(function (children) {
                    childWidget = make(children);
                    parent.appendChild(childWidget);
                    expand.src = 'expanded.png';
                    stateUnknown = false;
                    isOpened = true;
                    opencb();
                },
                function (reason) {
                    throw reason;
                });
                        
                stateUnknown = true;
            }

            function close() {
                parent.removeChild(childWidget);
                expand.src = 'expandme.png';
                isOpened = false;
                closecb();
            }

            nodeObj = {
                openClose: function () {
                    if (stateUnknown) {
                        return;
                    }
                    if (isOpened) {
                        close();
                    } else {
                        open();
                    }
 
                },       
                select: function () {
                    clickable.style.backgroundColor = highlightColor;      
                },
                unselect: function () {
                    clickable.style.backgroundColor = 'transparent';     
                },
                refresh: function () {
                    if (stateUnknown || !isOpened || (null === expand)) {
                        return;
                    } else {
                        close();
                        open();
                    }
                    
                }
            };

            clickable.onmouseover = function (ev) {
                nodeObj.select();
                return mouseovercb(ev);
            };
            clickable.onmouseout = function (ev) {
                nodeObj.unselect();
                return mouseoutcb(ev);
            };
            clickable.onclick = clickcb;
            clickable.onmousedown = mousedowncb;
            clickable.onmouseup = mouseupcb;
            if (null !== expand) {
                expand.onclick = nodeObj.openClose;
            }
            setrefreshcb(nodeObj.refresh);
            return nodeObj;
        }
        table = createElement('table');
        table.setAttribute('cellpadding', '2px');
        table.setAttribute('cellspacing', '0');
        for (itemidx = 0; itemidx < rootitems.length; itemidx += 1) {
            item = rootitems[itemidx];
            expand = null;

            if (item.expandable) {
                expand = createElement('img');
                expand.src = 'expandme.png';
            }
            tr = createElement('tr');
            expandCell = createElement('td');
            expandCell.width = '16px';
            expandCell.setAttribute('align', 'center');
            expandCell.setAttribute('valign', 'top');
            if (null !== expand) {
                expandCell.appendChild(expand);
            }
            contentCell = createElement('td');
            contentCell.style.padding = '1px';
            contentTable = createElement('table');
            contentTable.setAttribute('cellspacing', '0');
            contentTable.setAttribute('cellpadding', '1px');
            contentRow = createElement('tr');

            clickable = contentTable;
            for (eidx = 0; eidx < item.elements.length; eidx += 1) {
                element = item.elements[eidx];
                ecell = createElement('td');
                ecell.appendChild(element);
                contentRow.appendChild(ecell);
                if (eidx === item.clickable) {
                    clickable = element;
                }
            }
            contentTable.appendChild(contentRow);
            contentCell.appendChild(contentTable);
                        
            tr.appendChild(expandCell);
            tr.appendChild(contentCell);
            makeNodeObj(contentCell, clickable, expand,
                        item.getchildrencb, item.opencb, item.closecb, item.clickcb,
                        item.mousedowncb, item.mouseupcb, item.mouseovercb,
                        item.mouseoutcb, item.setrefreshcb);
            table.appendChild(tr);
            numChildren += 1;
        }
        if (0 === numChildren) {
            table.appendChild(emptyRow);
        }
        return table;
    }

    return {
        // rootitems is an array of objects, each of which has the properties:
        //     elements   -- an array of DOM elements
        //     clickable  -- an index of 'elements' that indicates which of the
        //                   elements is to be interactable. mouse events from
        //                   this element will be propagated via the callbacks
        //                   if invalid (e.g. -1) then the container holding all
        //                   of the elements is interactable
        //     expandable -- boolean: whether or not this can be expanded
        //     clickcb    -- a callback for when this item is clicked
        //     getchildrencb -- a callback for when this item is expanded which
        //                    should return a promise for an array that contains
        //                    the next-level items
        //     mousedowncb -- a callback for onmousedown events for this item
        //     mouseupcb   -- a callback for onmouseup events for this item
        //     mouseovercb -- a callback for onmouseover events for this item
        //     mouseoutcb  -- a callback for onmouseout events for this item
        //     opencb      --  if expandable, a cb for when this item is opened
        //     closecb     --  if expandable, a cb for when this item is closed
        //     setrefreshcb -- if expandable, a cb that we call, passing a
        //                     function that can be called to refresh this
        //                     item
        make: make
    };
};
