
from allmydata.test.tilting import TiltingMixin
from twisted.trial import unittest
from twisted.internet import defer

# web browsers may take a long time to load
timeout = 1200


class TahoeExplorerTestMixin:
    def start_gateway(self):
        self.settings['TEST_URL'] = "http://127.0.0.1:9999/test"

    def test_dummy(self):
        self.failUnless(True)


class FirefoxTest(TahoeExplorerTestMixin, TiltingMixin, unittest.TestCase):
    def configure(self):
        self.browserName = "firefox"

class InternetExplorerTest(TahoeExplorerTestMixin, TiltingMixin, unittest.TestCase):
    def configure(self):
        self.browserName = "ie"

class SafariTest(TahoeExplorerTestMixin, TiltingMixin, unittest.TestCase):
    def configure(self):
        self.browserName = "safari"

class ChromeTest(TahoeExplorerTestMixin, TiltingMixin, unittest.TestCase):
    def configure(self):
        self.browserName = "chrome"
