import sys, os, shutil, exceptions

# from allmydata.storage.mutable import MutableShareFile
# MUTABLE_MAGIC = MutableShareFile.MAGIC
MUTABLE_MAGIC = "Tahoe mutable container v1\n" + "\x75\x09\x44\x03\x8e"

# from allmydata.util.fileutil import make_dirs
def make_dirs(dirname, mode=0777):
    """
    An idempotent version of os.makedirs().  If the dir already exists, do
    nothing and return without raising an exception.  If this call creates the
    dir, return without raising an exception.  If there is an error that
    prevents creation or if the directory gets deleted after make_dirs() creates
    it and before make_dirs() checks that it exists, raise an exception.
    """
    tx = None
    try:
        os.makedirs(dirname, mode)
    except OSError, x:
        tx = x

    if not os.path.isdir(dirname):
        if tx:
            raise tx
        raise exceptions.IOError, "unknown error prevented creation of directory, or deleted the directory immediately after creation: %s" % dirname # careful not to construct an IOError with a 2-tuple, as that has a special meaning...


def copy_mutable_shares(src_base, dest_base, out=sys.stdout, err=sys.stderr):
    src_shares = os.path.join(src_base, "storage", "shares")
    if not os.path.exists(src_shares):
        print >>err, "Shares directory '%s' does not exist." % (src_shares,)
        return 1

    for short_si in os.listdir(src_shares):
        src_short = os.path.join(src_shares, short_si)
        for si in os.listdir(src_short):
            src_si = os.path.join(src_short, si)
            files = os.listdir(src_si)
            if files:
                f = open(os.path.join(src_si, files[0]), "rb")
                prefix = f.read(32)
                f.close()
                if prefix == MUTABLE_MAGIC:
                    print >>out, "Copying <%s>..." % (si,),
                    dest_si = os.path.join(dest_base, "storage", "shares", short_si, si)
                    make_dirs(dest_si)
                    for file in files:
                        shutil.copy2(os.path.join(src_si, file), dest_si)
                    print >>out, "done"

    return 0

if __name__ == "__main__":
    if len(sys.argv) != 3:
        print >>sys.stderr, "Usage: python copy_mutable_shares.py SRC_BASEDIR DEST_BASEDIR"
        sys.exit(1)

    sys.exit(copy_mutable_shares(sys.argv[1], sys.argv[2]))
