from allmydata.node import Node
from allmydata.introducer.client import IntroducerClient
from allmydata.util import log
import allmydata

class relay(Node):
    def __init__(self,basedir=u'.'):
        self.PORTNUMFILE = "derp"##not setting this causes Node.__init__ to raise
        Node.__init__(self,basedir)
        self.ICs = []
        for Ifurl in self.get_config('node','Ifurls','').split('---'):
            #not sure of the perfered way to get a list from tahoe.cfg
            self.ICs.append(self.init_intro(Ifurl))
        self.bridge = bridge(self.ICs)
    def init_intro(self,furl):
        IC = IntroducerClient(self.tub,furl,self.nickname,
                              str(allmydata.__full_version__),"1.0.0")
        d = self.when_tub_ready()
        def _start_introducer_client(res):
            IC.setServiceParent(self)
        d.addCallback(_start_introducer_client)
        d.addErrback(log.err,facility="tahoe.init",
                     level=log.BAD, umid="URyI5w")
        return IC
class bridge():
    def __init__(self,ICs):
        self.ICs = ICs
        for Ic in self.ICs:
            Ic.subscribe_to('storage',self.resend_ann)
    def resend_ann(self,serverid,ann_d):
        for Ic in self.ICs:##resends to the ic recved from, could be less redundent
            self.resend_to(Ic,ann_d)
    def resend_to(self,IC,ann_d):
        ann = self.ann_d_to_ann(ann_d)
        IC._published_announcements.add(ann)
        IC._maybe_publish()
    def ann_d_to_ann(self,ann_d):
        return (ann_d["FURL"],ann_d["service-name"],"RIStorageServer.tahoe.allmydata.com",
                ann_d["nickname"].encode(),ann_d["my-version"],ann_d["oldest-supported"])
