$(function () {
    function displayStats(data) {
	$("#started").text(new Date(data.started * 1000).toString());
	$("#si").text(data.storage_index);
	$("#helper").text(data.helper ? "Yes" : "No");
	$("#total_size").text(data.total_size);
	$("#progress").text(data.progress * 100);
	$("#status").text(data.status);
    }

    function displayPopups(jq) {
	/*
	within the elements in jq, whenever the mouse is within one of
	those, clone its .popup child and follow the mouse with that
	clone.
	*/

	var currentPopup, popupIsFor;
	jq.mousemove(function (ev) {

	    if (ev.target != popupIsFor) {

		if (currentPopup) {
		    currentPopup.remove();
		}
		currentPopup = $(this).find(".popup").clone();
		currentPopup.show();
		$("body").append(currentPopup);
		popupIsFor = ev.target;
	    }
	    currentPopup.css({left: ev.pageX + 10, top: ev.pageY - 15});
	}).mouseleave(function (ev) {
	    if (ev.target == popupIsFor) {
		currentPopup.remove();
		popupIsFor = null;
	    }
	});
	
    }

    function onDataReceived(data) {
	displayStats(data);
	
	var pxPerSec = 200;
	function xForTime(t) { return (t - data.started) * pxPerSec; }
	function dxForTime(dt) { return dt * pxPerSec; }

	function timelineBar(event) {
	    var sx = xForTime(event.start_time), ex = xForTime(event.finish_time);
	    var ret = $("<div>").addClass("timing").css({
		marginLeft: sx+"px", 
		width: (ex - sx) + "px"});
	    return ret;
	}
	function makeRow(cls) {
	    return $("<div>").addClass("event "+cls).append($("<div>").addClass("expander").text("+"));
	}

	function makePopup(js) {
	    ret = $("<div>").addClass("popup").hide();

	    for (k in js) {
		ret.append($("<div>").text(k+": "+JSON.stringify(js[k])));
	    }
	    return ret;
	}

	var eventsDiv = $("#events");

	var eventRows = []; // [sortkey, elem]

	$.each(data.read, function (i, ev) {
	    var row = makeRow("read");
	    
	    row.append($("<div>").addClass("label").text("read() request"))
	       .append($("<div>").addClass("value").text("bytes_returned="+ev.bytes_returned))
		.append(timelineBar(ev).append(makePopup(ev)));

	    eventRows.push([ev.start_time, row]);
	});

	$.each(data.dyhb, function (i, ev) {
	    var row = makeRow("dyhb");

	    row.append($("<div>").addClass("label").text("DYHB request"))
	       .append($("<div>").addClass("value").text("share numbers "+JSON.stringify(ev.response_shnums)))
               .append(timelineBar(ev).text(ev.serverid).append(makePopup(ev)));

	    eventRows.push([ev.start_time, row]);
	});

	$.each(data.segment, function (i, ev) {
	    var row = makeRow("segment");

	    row.append($("<div>").addClass("label").text("segment() request"))
	       .append($("<div>").addClass("value").text("num="+ev.segment_number+" start="+ev.segment_start))
     		.append(timelineBar(ev).text(ev.success ? "ok" : "fail").append(makePopup(ev)));
	    
	    eventRows.push([ev.start_time, row]);
	});

	$.each(data.block, function (i, ev) {
	    var row = makeRow("block");

	    var duration = Math.round((ev.finish_time - ev.start_time) * 1000) + "ms"

	    row.append($("<div>").addClass("label").text("block() request"))
	       .append($("<div>").addClass("value").text("shnum="+ev.shnum))
	       .append(timelineBar(ev).text(ev.shnum).append(makePopup(ev)))
		.append($("<div>").addClass("timelinePost").css("marginLeft", xForTime(ev.finish_time)+5).text(duration));
	    
	    eventRows.push([ev.start_time, row]);
	});

	eventRows.sort();
	$.each(eventRows, function (i,r) {
	    eventsDiv.append(r[1]);
	});
	displayPopups($(".timing"));
    }
    $.ajax({url: "event_json",
            method: 'GET',
            dataType: 'json',
            success: onDataReceived });
});