#! /usr/bin/env python

from twisted.python.filepath import FilePath
import argparse, sys

def MakeAFileWithNBytes(N, Directory):
    FP = Directory.child('FileWith' + str(8*int(N)) + 'Bytes')
    fh = FP.open(mode='w')
    for i in xrange(N):
        fh.write("%7.d"%(i*8) + '\n')
    fh.close()

def main():
    listofnumbers = [ 3
                      , 2**(17-3)
                      , 2**(18-3)
                      , 2**(19-3)
                      , 2**(20-3)
                      , 2**(21-3)
                      , 2**(22-3)
                      , 2**(23-3)]
    parser = argparse.ArgumentParser(description='Create a set of base 2 exponentially expanding files.')
    parser.add_argument('target_directory', type=str, help='directory where files will be created')
    args = parser.parse_args()
    TD = FilePath(args.target_directory)
    if TD.isdir():
        print "Argument %s is expected to not exist, prior to script invocation." % TD.path
        sys.exit(-1)
    TD.makedirs()
    for Size in listofnumbers:
        MakeAFileWithNBytes(Size, TD)

if __name__ == '__main__':
    main()
