#!/usr/bin/env python

import os

from allmydata.util import fileutil, idlib
from allmydata.storage import storage_index_to_dir

newtopdirs = set()
for sidir in os.listdir('.'):
    if idlib.could_be_base32_encoded_l(sidir, 128):
        newtopdir = idlib.b2a_l(idlib.a2b(sidir)[:2], 14)
        if not newtopdir in newtopdirs:
            newtopdirs.add(newtopdir)
            fileutil.make_dirs(newtopdir)
        try:
            os.rename(sidir, os.path.join(newtopdir, sidir))
        except EnvironmentError:
            # Maybe there is already a sidir there and we need to move the 
            # contents of this sidir into it.
            for fn in os.listdir(sidir):
                os.rename(os.path.join(sidir, fn), os.path.join(newtopdir, sidir, fn))
            # Okay, good, now rmdir the old one.
            os.rmdir(sidir)
        
        
