---
title: Tahoe-LAFS - Nuts & Bolts Meetings

---

# Tahoe-LAFS - Nuts & Bolts Meetings
[Location](https://meet.jit.si/AccurateFiltersManipulateBefore)
[Legacy meeting notes](https://tahoe-lafs.org/trac/tahoe-lafs/wiki/WeeklyMeeting)
[This doc](https://hackmd.io/DzedQERvRLWaaaeo-gtDhA)
[Consolidation of notes](https://tahoe-lafs.org/trac/tahoe-lafs/ticket/4104)
[IRC Group: #tahoe-lafs@libera.chat]


# 17 Aug, 2025
## Attendees

- Blaise
- Jeff
- Flo
- B3n

### Tour of  The staged [forge](https://forge.of.tahoe-lafs.org/)

- @b3n and @hacklschorsch are org admins
- @blaise is non-member (to serve as guinea pig)
- @jwjacobson is (non-migrated) new member
- Workflow using Github-compatible [Actions](https://forge.of.tahoe-lafs.org/tahoe-lafs/web-landing-page/actions)
- Tracking requests for @meejah in: https://tahoe-lafs.org/trac/tahoe-lafs/ticket/4183 
- Legacy meeting notes will get migrated from the [trac wiki](https://tahoe-lafs.org/trac/tahoe-lafs/wiki/WeeklyMeeting#April22024)


### Web assembly tahoe client ( @hacklschorsch )
- For running the client in the browser (and move the exposure boundary closer to the user app).

### updated SFTP tutorial
- @hacklschorsch edited the [blog post](https://privatestorage-staging.com/sftp-tutorial-without-web-browser/blog/introducing-sftp/) about SFTP.


# 12 Aug, 2025
## Attendees

- Blaise
- Jeff

### Improving private-facts core

- https://github.com/private-facts/private-facts/pull/12 includes fixes to regressions and a number of other clean ups.
- Important: we noticed that the client needs to be able to find the storage server so that is a failure we didn't consider.
- Now you can run `just dev` and `just hello` and have a better experience.

### Approaching the character limit of HackMD
- maybe it's time to migrate, or move to some kind of wiki?


# 5 Aug, 2025
## Attendees

- Blaise
- Jeff
- @hacklschorsch 
- @meejah

### SFTP client still works well
- Flo has good experience with the S/FTP transport backing up local files
- A tutorial for Windows: https://privatestorage-staging.com/blog-sftp-frontend/blog/anything-goes-with-sftp/

### Private Facts 

- private-facts.org points to a gh-page
- MIT license for now (PF is mostly tools for using Tahoe, not Tahoe itself)


# 29 Jul, 2025
## Attendees
- Blaise
- Jeff
- @hacklschorsch


## News: Zulip forum for discussions related to "private-facts" (aka Tahoe in exile)
Invite link: https://private-facts.zulipchat.com/join/enaxastululml2pwfo5e2mvv/

## Why Zulip and not {Discourse, Discord, Slack, IRC, GitHub, Xitter, Gitter, Matrix, }

- It's topic threaded
- Open Source
- Written in python
- Browser and mobile clients
- OAUTH with GitHub , GitLab , Google , and more


## New infra waiting for DNS click-ops (and maybe some finishing touches)
- https://forge.of.tahoe-lafs.org/
- https://home.of.tahoe-lafs.org/

- https://forge.of.tahoe-lafs.org/tahoe-lafs/web-landing-page
- https://github.com/tahoe-lafs/infrastructure/blob/main/nix/hosts/webforge/forgejo.nix

### Blockers:
- accounts registration (eg. Flo, Blaise, Jeff)

# 22 Jul, 2025
## Attendees
- Blaise
- Ben (@btlogy)
- Chris
- Flo (@hacklschorsch)
- Jeff

## Topics

### Github Action billing issue resolved ! - #4182
(aka: the most expensive penny.)


### Private Facts

> "A showcase for client-first security using capability theory and Tahoe-LAFS."
(currently a github org to serve as an umbrella for projects similar to, or working with, Tahoe-LAFS)
(inspired by palletsprojects.com)

Internal Goals:
- provide visibility to the contributors
- boost reputation, portfolio for newer contributors
- fast prototyping of example apps
- easy navigation to related material

    Now: 
    - https://github.com/private-facts
    - private-facts using FastAPI ( a fullstack app)
    - private-facts using Svelte (a TypeScript client)

    Next: 
    - Contacts: facts@private-facts.org , toots.pio-p.io/@private-facts , talk.tutes.ai/forums/private-facts, 
    - Code of Conduct
    - Related projects....
    - Awesome capability theory resources
    - Benchmarks (testgrid up time, latency, volume...)
    - Core: https://gitlab.com/adrianmay1/bala-lafs
    - Mobile: https://gitlab.com/adrianmay1/bala-lafs-mobile
    - Cookbook: 
        - DIY grid
        - DIY introducer

Started by @blaisep and @jwjacobson.

### LA grant is likely closing this week
- no more money left (budget used up + late bill from Obsidian turned up behind the sofa)
- no feedback from the community since Feb whether we can continue?
- @hacklschorsch offers (continuing) caring for the test grid

### Rewrite of the mobile app+lib
- Adrian is finishing the collaboration with LA and might be continuing working on bala-lafs and bala-lafs-mobile a little while longer.  He is seeking funding.

### Passphrase recovery
- no time to make it as good as hoped first
- Chris will update on the final state of project next week

### Web-landing page migration from Trac #4183
- pending on DNS click OPS (request sent to Meejah last week)
- expecting downtime to obtain the Let's encrypt certificate
- rewrite/redirect rules will still sent the end-users to the current Trac tickets/wiki pages

### Trac migration to Forgejo #4161
- GHA are back, so last PR(s) will be merged asap (remote backups)
- then async OPS will be required to migrate the data (likely after Ben's vacation)

# 15 Jul, 2025
## Attendees
- Adrian
- Ben (@btlogy)
- Chris
- Flo (@hacklschorsch)
- Jeff

## Topics

### GitHub Actions stopped (more like GitHub inactions still) - #4182

- Still not fixed: GHA are still failing and no feed back from GH support
- LeastAutority is trying to add a credit card, hoping this will unlock the GHA

### Shared secrets - #4177

- Ben asked if anyone else than LeastAuthority could be involved (w/ a PGP key)
- Chris advised to ensure any new recipient would explicitely approve using his PGP key (even if already known - e.g. Brian or Meejah)
- Repository ready to be tested by Flo: https://github.com/tahoe-lafs/infrastructure-pass


### Mobile app work in progress


# 8 Jul, 2025
## Attendees
- @blaisep
- Adrian
- Ben (@btlogy)
- Chris
- Flo (@hacklschorsch)
- Meejah

## Topics

### Bala-LAFS: Haskell Core library completed! Mobile App is next...

- Core: https://gitlab.com/adrianmay1/bala-lafs
- Mobile: https://gitlab.com/adrianmay1/bala-lafs-mobile

### Namespacing the (Haskell) library source repos...

Decided:
  - Gonna clone gitlab:adrianmay1/bala-lafs and bala-lafs-mobile into tahoe-lafs gitlab space
  - bala-lafs-mobile won't have the history of tahoe-lafs-mobile: just its own history
 
Options:

1. Make a new organization somewhere (GitLab, GitHub etc)
   - Pro: Clearer for us insiders what fits with what
   - Con: Less clear for outside people how this relates to tahoe-lafs
   - Con: Bala-LAFS unknown, might need explaining
   - Con: Proliferation of organizations (already confusing between GitHub, GitLab, Trac, ...)

2. Open new repositories in the GitLab tahoe-lafs organization, keeping the "bala" name/prefix
   - Pro: It would be clear enough that this is different from the tahoe- repositores
   - Pro: It would also be clear that the software is supposed to work with tahoe* things
   - Pro: All members are already there
   - Pro: fewer places to look for tahoe stuff
   - We would still publish (in the store) under the 'tahoe-lafs-mobile' name when everything works well

## GitHub Actions stopped (more like GitHub inactions now, innit)

- Seems like credit card failure is the reason for GHA not working
- Chris has reached out to GitHub support

## Magic Internet project seems to not be happening anymore

- There's a [group on OpenCollective](https://opencollective.com/tahoe-lafs/projects/magic-internet), but not much more.  The legal entity that was planned is not going to happen anymore.
- Meejah says we should ask Pete.
  - @hacklschorsch asked Pete via eMail on 2025-07-10.


## Links:
- Python SPAKE module: https://github.com/warner/python-spake2
- Spake2 PyPi: https://pypi.org/project/spake2/

# 1 Jul, 2025
## Attendees
- Adrian
- Ben (@btlogy)
- blaisep

## Topics

### Mobile App

About 1 day from completing the core library and magic folder but for validation.

Starting on adapting the mobile app to the new libraries. This is higher risk therefore more urgent than validation.

### MoveOffTrac #4261

Working (still) on the missing bits for Forgejo:
- Local mailer in place, checking the DMARC reports [infrastructure#68](https://github.com/tahoe-lafs/infrastructure/pull/68) and [infrastructure#70](https://github.com/tahoe-lafs/infrastructure/pull/70)
- Local and off-site nightly backups [infrastructure#73](https://github.com/tahoe-lafs/infrastructure/pull/73) and [infrastructure#75](https://github.com/tahoe-lafs/infrastructure/pull/75)

### Infrastructure secrets #4177
- New private repository: [infrastructure-pass](https://github.com/tahoe-lafs/infrastructure-pass)
- New dedicated GH accounts for Upptime, CI/CD and OAuth2 (e.g. [forge-tahoe](https://github.com/forge-tahoe))

# Jun 24, 2025
## Attendees
- Adrian
- Chris
- Flo (@hacklschorsch)
- Ben (@btlogy)
- Blaise (@blaisep)
- Meejah

## Topics

### MoveOffTrac - mailer

Working (back) on the missing bits for Forgejo:
- https://github.com/tahoe-lafs/infrastructure/pull/68

### Mobile app - Haskell - Bala-LAFS
Adrian shows off the new structure of the Haskell code base. https://gitlab.com/adrianmay1/bala-lafs

#### Highlights:
- Namespace = Bala (also a lake, to not confuse with the original implementation)
- Reduced LOC from 10k to 4k.
- Shares -> Capabilities -> Directories -> Magic Folders (ascending order of abstraction)

#### Challenges, Caveats and Oddities:
- Asking servers for offers, then getting and shuffling lists of shares, consuming the offers.
- Getting multiple offers for the SAME share.
- @meejah observed that the python client has an [algorithm for consuming share offers](https://tahoe-lafs.readthedocs.io/en/latest/specifications/servers-of-happiness.html#upload-strategy-of-happiness), part of the servers-of-happiness strategy.
- The UEB can confirm everything in the capability string. Don't depend on the capability string, because that can be modified.
- Naming scheme is: a body of water near the place the project was invented.
  
- Early stage compromises (decisions to revisit later)
  - `GBS.api` is the protocol description written in `servant` (Haskell REST interface library)
  - One big type for all errors 
    
# Jun 17, 2025
## Attendees
- Blaise (@blaisep)
- Chris
- Flo (@hacklschorsch)
- Jeff

## Topics

- Did some ensemble programming on the private_facts app and the CRUD Tahoe client library

## Links

- Curated Ansible roles by Robert de Bock https://robertdebock.nl/ansible.html#roles
- https://tahoe-lafs.readthedocs.io/en/latest/frontends/webapi.html#writing-uploading-a-file


# Jun 10, 2025
## Attendees
- Meejah
- Blaise
- Jeff

## Topics

### Tahoe test client WIP

@jeff and @blaisep moved most of the integration tests from gridsync into the private facts repo and @hacklschorsch pointed out that the ultimately want to accomplish tw results:
- package a self-contained ("embedded") tahoe dev server for easy mocking in tests.
- emulate CRUD behavior using the REST interface (ie. the "right hand side" of the private facts proxy)
This will help anyone developing TAHOE-LAFS to create tests without having to reimplement a client library.

**Lesson Learned:** We had been trying to do both inside the same effort and decoupling them simplifies both the development and the usage.

# Jun 3, 2025
## Attendees
- Meejah
- Ben
- Flo
- Chris

## Topics

### Tor test suite fixes [#4167](https://tahoe-lafs.org/trac/tahoe-lafs/ticket/4167)

- Also: https://tahoe-lafs.org/trac/tahoe-lafs/ticket/3943
- PRs:
  - [tahoe-lafs#1435](https://github.com/tahoe-lafs/tahoe-lafs/pull/1435)

Flo reports some progress made with Adrian
And also some problems with Chutney on Windows

### Infrastructure as Code to manage DNS configurations [#4162](https://tahoe-lafs.org/trac/tahoe-lafs/ticket/4162)

Subdomain is not well supported by many providers (except AWS/Google and Azure...) - especially when it comes w/ DNSSEC.
The current setup with Hetznr works ok, so we can move on while preparing the delegation of the 2nd level domain.  

### Intermittent 502 response from Trac [#4178](https://tahoe-lafs.org/trac/tahoe-lafs/ticket/4178)
The issue may not be too painfull, but Meejah suggests to ask others w/ access: Brian or JP.
(meejah believes JP only has similar access, that is "trac" user only)

### Manage shared secrets required to interact with the infrastructure [#4177](https://tahoe-lafs.org/trac/tahoe-lafs/ticket/4177)
Proposing a git repo using `pass` to share secrets like GH bots and Hetzner account holding API tokens used for automation.

### master tests don't work with wormhole 0.19.2 [#4180](https://tahoe-lafs.org/trac/tahoe-lafs/ticket/4180)

CI is broken (again) and prevents further merge.
meejah approved contribution https://github.com/tahoe-lafs/tahoe-lafs/pull/1438
...and attempted to fix CI / errors from new, optional magic-wormhole arg: https://github.com/tahoe-lafs/tahoe-lafs/pull/1439 

# May 27, 2025

## Attendees
- Jeff
- Ben
- Blaise
- Flo
- Chris

### Running Tahoe in production... a survival kit
- What would we need to be confident about running Tahoe-LAFS in production?


### Fantasy: Tahoe as a CDN
- expose APIs (eg. minio, graphQL)
- backend for proxy/cache (eg. Fastly, CloudFlare, Akamai)
- back end for resilient services like Radicle https://radicle.xyz/guides/protocol or https://www.lothar.com/blog/55-Git-over-Tahoe-LAFS/

### Infrastructure as Code to manage DNS configurations [#4162](https://tahoe-lafs.org/trac/tahoe-lafs/ticket/4162)
- DNS subzone support partly working with Hetzner
- Considering changing to https://desec.io/ Free, OpenSource, EU based (but enforcing DNSSEC)
- Or Hurricane Electric https://dns.he.net/

### Intermittent 502 response from Trac [#4178](https://tahoe-lafs.org/trac/tahoe-lafs/ticket/4178)
Monitoring Upptime was reporting intermittent 502
But these errors have disappeared since May 24: maybe solved

### Manage shared secrets required to interact with the infrastructure [#4177](https://tahoe-lafs.org/trac/tahoe-lafs/ticket/4177)
Credential management discussion
To reduce bus factor, consider storing the creds in a shared password vault 

- (eg. LA uses https://www.passwordstore.org/)
- consider creating bot ids to own tokens instead of individuals (e.g. for upptime-infrastructure)
- scope will be excluding secrets already managed with SOPS https://getsops.io/ 

    [ ] Write up a list of requirements or use cases?
    
### Extracting the gridsync integration tests
- Jeff copied most of the tests into the private facts repo
- obstacles: 
    - without zkapauthorized, most tests fail, WITH zkap all but one PASS.
    - python <=3.12, no wheels for os x >12 (without rebuild), tahoe <=1.18
- Chris working on that for some of the remaining foundation deliverables.
[ ] Save error messages to help troubleshoot.

### Chris (and Flo) on tor integration tests
- Chutney https://gitlab.torproject.org/tpo/core/chutney to spin up tests. Problems with windoze
    - uses __Specification by Example__ (yay!!) https://www.chutney-testing.com/documentation/actions/introduction/
- PRs 1435 and 1437
- Goal: GBS (HTTP) client to support Tor

Links:
- Marimo is cool for tutorials and code demos: https://docs.marimo.io/guides/apps/

# May 20, 2025

## Attendees
- Jeff
- Ben

## Notes
- DNS configuration is partly defined as code (subdomain of.tahoe-lafs.org):
  https://github.com/tahoe-lafs/infrastructure/blob/3cc71938674e0a26027363d21707bd3ee629389e/tf/core/dns_of-tl-org.tf
- #4161 Forgejo has been provisionned for MoveOffTrac
  https://forge.of.tahoe-lafs.org/
  Feedback from Jeff: the home page does not show any project
  Can we change that?
- web-landing-page has also been provisionned too
  https://home.of.tahoe-lafs.org/
  But the code and CI/CD still need work (not more eval links)
- legacy services from Linode also available here:
  https://legacy.of.tahoe-lafs.org/
- #4175 Upptime status page is live and can be improve:
  https://tahoe-lafs.github.io/infrastructure-upptime/
- #4176 Disk space on Linode has been freed by Meejah on Sat 18th, but we still get some 502 (also during this N&B)

# May 13, 2025

## Attendees
- meejah
- @hacklschorsch 
- Ben 
- Jeff
- Chris

## Notes
- Flo made some fixes with Adrian to the mobile app, got the [man page finalized](https://github.com/tahoe-lafs/tahoe-lafs/pull/1433), tried last week to fix the CI but not totally done? Tor integration tests need some attention
- Jeff reports some progress with gridsync tests in Private Facts
- Flo recommends checking the [Readme on Gitlab for more info on how to use the mobile app](https://gitlab.com/tahoe-lafs/tahoe-lafs-mobile#usage). Also better to sideload APK [from CI](https://gitlab.com/tahoe-lafs/tahoe-lafs-mobile/-/pipelines?page=1&scope=finished&ref=main) because it more up to date than the [Google Play version](https://play.google.com/store/apps/details?id=org.tahoe_lafs.tahoe_lafs_mobile)
- Ben brings up [ticket 4162](https://tahoe-lafs.org/trac/tahoe-lafs/ticket/4162), wanting to move to Hetzner but unable to do so fully because of lack of response from Brian. Meejah will follow up in comments to the issue itself
- [Ticket 4175](https://tahoe-lafs.org/trac/tahoe-lafs/ticket/4175), improving monitoring in response to the site being down sometimes. Working on tahoe-upptime using [upptime](https://github.com/upptime/upptime)
- Close to bringing the new site live but hampered by DNS issues (4162 above)

## Links
- https://gitlab.com/tahoe-lafs/tahoe-lafs-mobile
- https://gitlab.com/tahoe-lafs/tahoe-lafs-mobile/-/pipelines?page=1&scope=all&ref=main
- https://tahoe-lafs.org/trac/tahoe-lafs/ticket/4162
- https://tahoe-lafs.org/trac/tahoe-lafs/ticket/4175
- https://github.com/upptime/upptime

# May 6, 2025

## Attendees
- Ben 
- Jeff
- Chris

## Notes
- Ben shows off the newly redesigned welcome page layout - contains redirects to the legacy page for certain unmigrated content
- Ben's DNS PR: https://github.com/tahoe-lafs/infrastructure/pull/49 in preparation for the migration 
- Brian difficult to get in touch with
- Jeff reports successful creation of tahoe_server fixture from Gridsync source; Chris recommends tahoe_integration tests

## Links
- https://nip.io/


# Apr 29, 2025

## Attendees
- @hacklschorsch 
- Jeff
- Chris

## Notes
- Jeff: trying to use gridsync
- Chris: Someone should make a generic Python client for Tahoe

# Apr 22, 2025

## Attendees
- Ben
- Chris
- @hacklschorsch 
- Jeff

## Notes

- Ben: Setting up a Hetzner account for Tahoe-LAFS things, to be transferred to Tahoe-LAFS (whom exactly?)
- Ben: No progress on website (besides opening a [repo](https://github.com/tahoe-lafs/web-landing-page)) or issue tracker (pending on required DNS changes)
- Flo: Reporting on NURLv0/NURLv1, implementing NURLv0 in the Haskell client: https://gitlab.com/tahoe-lafs/tahoe-great-black-swamp/-/merge_requests/7
- Jeff: Working on Private Facts integration test suite with Blaise, going from GridSync tests
  - Chris: The GridSync abstraction of Tahoe should be fairly readable and high-level

# Apr 15, 2025

## Attendees
- B3n
- Blaise
- Chris
- @hacklschorsch 
- Jeff

### Web Landing page code repo

https://github.com/tahoe-lafs/web-landing-page

likely going to home.tahoe-lafs.org

### Web sockets support in Twisted

Comment/Suggest at:
https://github.com/twisted/twisted/pull/12397

### Migration of tahoe-lafs.org DNS

https://tahoe-lafs.org/trac/tahoe-lafs/ticket/4162#comment:14
    TL;DR: 
    New records on gandi will be:

        ```
        tahoe-lafs.org.		60	IN	NS	hydrogen.ns.hetzner.com
        tahoe-lafs.org.		60	IN	NS	helium.ns.hetzner.com
        tahoe-lafs.org.		60	IN	NS	oxygen.ns.hetzner.com
        ```

## Links
https://auto.sesser.at/ wicked fast & tiny web site
https://github.com/hacklschorsch/auto.sesser.at the source code
https://html5up.net/ free web code samples


# Apr 8, 2025

## Attendees
- Jeff
- Blaise
- Chris
- @hacklschorsch 

## Issue tracking Migration

- [Preview of Forgejo instance (WIP)](https://forge.lafs.eval.latfa.net/tahoe-lafs/trac/issues)
    - [How to pronounce Forgejo](https://forgejo.org/static/forgejo.mp4) ^^

#### UNblock 4162: One step task Gandi authZ organization change: for DNS zone changes

In response to the current proposal to [automate the DNS maintenance](https://tahoe-lafs.org/trac/tahoe-lafs/ticket/4162#comment:7) 
we decided to make a tactical change: [update the records manually](https://tahoe-lafs.org/trac/tahoe-lafs/ticket/4162#comment:10) to expedite the transition.

Note: this process will consolidate issue tracking (`trac` ) with source control (`git`) ! So the developer experience will be similar to Github/Codeberg/Gitea/Forgejo

## Docs
- Landing page (Project Home)
    - [Preview (WIP)](https://www.lafs.eval.latfa.net/) (Jekyll static site generator)
- Wiki hosting
- Explain Tahoe loggin in 35 easy steps
- Explain Configuration formats


### Dreams of a python SDK

- inspired by https://github.com/gridsync/gridsync/blob/main/tests/integration/test_magic_folder_integration.py
- a pattern for process management https://github.com/gridsync/gridsync/blob/main/gridsync/supervisor.py
- a pattern for monitoring processes and events: https://github.com/gridsync/gridsync/blob/29edd61fa7dbd856fe757f0f11e911ebf6a44cab/gridsync/monitor.py#L372
- a pattern for filtering https://github.com/gridsync/gridsync/blob/main/gridsync/filter.py
- qt event loop with twisted https://github.com/twisted/qt5reactor/blob/master/src/qt5reactor/core.py


## Cool Links:
https://radicle.xyz/ (interesting science project for a mirror)
Gray Hat Python [pdf](https://github.com/ManhNho/Python-Books-for-Security/blob/master/Gray-Hat-Python-Python-Programming-For-Hackers-And-Reverse-Engineers.pdf)
Python compiler https://nuitka.net/
GPU without cuda https://www.modular.com/mojo

---

# Apr 1, 2025

## Attendees
- Blaise
- Chris
- Meejah
- Jeff 
- @hacklschorsch 

### Integration testing

- Unit tests use `twisted.trial`
- Integration tests use pytest
- [Tahoe-lafs](https://github.com/tahoe-lafs/tahoe-lafs/tree/master/integration)
- [Magic Folder](https://github.com/tahoe-lafs/magic-folder/tree/main/integration)
- [Link](https://github.com/tahoe-lafs/magic-folder/blob/main/integration/test_invite.py#L17)
- @Chris: If interested, some similar integration tests from the gridsync codebase (pytest-based, with real nodes, files, invites, network connections, and references to "Alice" and "Bob"): https://github.com/gridsync/gridsync/blob/main/tests/integration/test_magic_folder_integration.py
- Parmetrize tests with hypothesis: https://hypothesis.readthedocs.io/en/latest/
- Contract testing
    - Using Pact: https://docs.pact.io/getting_started/comparisons
    - Using Deal: https://pypi.org/project/deal/

### Storage Node Protocol: Foolscap vs GBS (http)
 - "Are we backwards compatible with FURLs?"
     - The [structure of fURLs and NURLs ](https://tahoe-lafs.readthedocs.io/en/latest/specifications/url.html#syntax) is similar (except for the trailing `v=1`)
     - Version 0 NURLs are different?
 - Ideally have a test suite _independent_ of the implementation so we could test implementations against the same criteria
 - We don't have a full protocol test to validate that an implementation handles (GBS, etc)  properly.
 - Long Term: web assembly for the browser to connect to storage servers.

### Glossary items
 - [Spookey (SPKI)](https://en.wikipedia.org/wiki/Simple_public-key_infrastructure) is used in fURLs and NURLs ([v0 and v1 a bit differently](https://tahoe-lafs.readthedocs.io/en/latest/specifications/url.html#versions)).
 - Verified Fakes (vs Mocks): https://pythonspeed.com/articles/verified-fakes/

### Links

https://tahoe-lafs.readthedocs.io/en/latest/specifications/url.html#versions
https://tahoe-lafs.readthedocs.io/en/latest/specifications/http-storage-node-protocol.html#transition
https://github.com/tahoe-lafs/tahoe-lafs/blob/master/src/allmydata/protocol_switch.py
https://hypothesis.readthedocs.io/en/latest/
Autobahn for websockets: https://github.com/crossbario/autobahn-python

# Mar 25, 2025

?? Blaise Absent

# Mar 18, 2025

## Attendees
- Blaise
- Meejah
- Jeff 
- @hacklschorsch 


#### Tahoe Client shipped for Android
- hacklschorsch: [Tahoe-LAFS client in the Google Play Store](https://play.google.com/store/apps/details?id=org.tahoe_lafs.tahoe_lafs_mobile)
- F-Droid on hold - currently we can't build the app fast enough.

#### Fediverse interest in migration to Forgejo
- @b3n contributed to [a mastodon thread](https://x0r.be/@b3n/114139604580878482) where people were looking for details on migrating to Forgejo. 

#### Flo's updates from BOBKonf conference
- Yjs CRDTs would work great with an append-only capability; Maybe we can emulate that for now with a range request to a read/write-cap?
  - Meejah: Multiple writers is the main reason for append-only cap, not past data security.
- Wants help reviewing new man pages for the Tahoe-LAFS Debian package
  - [grid-manager](https://github.com/tahoe-lafs/tahoe-lafs/pull/1432)
  - Updates to tahoe man page (opening a PR soon)

#### We need multi-writer append-only cap (but ...
- Tahoe can do it now with one writer... if you promise to always write to the same cap
- Tahoe can't support 2 or more writers.
- CRDTs compare versions and DETECT conflicts
- Magic folder will compare two versions (using clock timings) but it doesn't (yet) resolve conflicts.
    - There is a PR will display the conflicts so a human can resolve them
    - But it polls for an immutable
    - Meejah: We need a cryptographer to add support and it would be a nice upgrade (to avoid polling)

#### Capability theory 
- Ocap implementations are mostly about communication (Spritely Goblins, etc)
- Tahoe is one of the few for data capabilities
- 

### Links

- [yjs](https://github.com/yjs/yjs)
- https://yjs.dev/#features
- Rust port of CRDT https://github.com/y-crdt/y-crdt
- [Macaroons](https://github.com/rescrv/libmacaroons) is for data.


# Mar 11, 2025

### Attendees
- Chris
- Jeff 
- @hacklschorsch 

#### CI stuff
Flo managed to successfully download and zip together all artifacts so they upload properly,
But the Test PYPI token has expired and a new one needs to be generated:
[Relevant PR](https://github.com/tahoe-lafs/zfec/pull/121)
[Relevant issue](https://github.com/tahoe-lafs/zfec/issues/127)

#### Mobile app now available on the Play store
"Open testing" release at: https://play.google.com/store/apps/details?id=org.tahoe_lafs.tahoe_lafs_mobile

Needs better getting-started documentation because it cannot create anything on its own

#### A Haskell storage server implementation exists
but can't communicate with the Python client, maybe versioning issues
One issue is the eclectic logging of the Python implementation and the minimal logging of the Haskell implementation
Indiana Jones style code archaeology reveals a vast trove of well-designed Haskell code in tahoe-great-black-swamp
Just not sure of how to build the proper url

#### Possibility of lightweight HTML/JS-only apps with Tahoe-LAFS Client HTTP API
Just an html page that displays text or a text editor depending on read or write-cap
Or a picture gallery
Ecosystem of tiny web apps, like sandstorm?
Potentially using the GBS server?
These apps could themselves be stored in a Tahoe directory

# Feb 18, 2025

### Attendees
- Blaise
- Chris
- Jeff 
- @hacklschorsch 
- Meejah

#### Hosting multipoint video conferences.

[Pair on](https://sr.ht/~meejah/pear-on/) (what sets up ttyshare in magic wormhole) does not have a video multiplexer.... Maybe VLC has a server?
https://askubuntu.com/questions/56356/how-to-host-a-video-conference-with-vlvc
> I just found out that you can use VLC and VLVC to hold video conferences between 2-10 people, and that sounds amazing, hopefully removing the heavy lean on Skype. 
https://www.videolan.org/vlc/libvlc.html
http://breakthrusoftware.com/html/onlinedocs/kb/videomill/vlc.html
Python bindings https://github.com/oaubert/python-vlc

https://wiki.videolan.org/VideoLan_VideoConference/

Jitsi: uses webRTC and that is hard to punch through wormholes.


#### web sockets in Tahoe-lafs

https://github.com/tahoe-lafs/tahoe-lafs/blob/master/ws_client.py

#### Safer Serving Eliot logs: don't write to disk
Write logs to in memory files to reduce exposure of sensitive data
https://tahoe-lafs.org/trac/tahoe-lafs/ticket/3006
fixed https://github.com/tahoe-lafs/tahoe-lafs/pull/584

#### Upload Helper
- does the upload helper work?
- is it still useful? are uploads an issue in 2025?

#### Upload: Strategy of happiness

https://tahoe-lafs.readthedocs.io/en/latest/specifications/servers-of-happiness.html#upload-strategy-of-happiness

#### Deploying grid manager
a solution for private storage
Maybe use the test grid?

#### No new capability types
because we don't have cryptographers for cryptographic review.

## Feb 11, 2025

### Attendees
- Blaise
- Chris
- Jeff 

#### Private Facts API discussion, Chris' suggestions
- Consider using the CLI `alias` function for human readable references to capabilities.
- Consider saving capabilities in a local secrets manager.

## Feb 4, 2025

### Attendees
- Blaise
- Chris
- Jeff 
- Ben
- Meejah

#### FosDem Lightning talk
- Flo presented
- Link TBD
- No analytics because we don't control the DNS name.

#### Trac Migration
- Brian on board with DNS redirection, etc

#### Other items in progress, pending grant renewal
- LAFS rust crate
- Recovery workflow

#### What sequence diagramming tools work well?
- PlantUML is the most portable and future proof https://crashedmind.github.io/plantuml.github.io/
- Mermaid is the most beautiful, but very JavaScripty https://mermaid.js.org/intro/
- kroki.io is the umbrella project that runs everything https://kroki.io/
- excalidraw is good for drag&drop with a bit of import/export https://excalidraw.com/

## Jan 28, 2025

### Attendees
- Blaise
- Chris
- Flo (@hacklschorsch)
- Jeff 
- Meejah
- Pete


#### Pete has news from "Magic Internet" !

- Opportunity for differentiating the guiding principals from the legacy tech debt!
- Python Tahoe is moving to Open Collective for managing grants
- Itamar working on some outstanding 3.13 compatibility requirements
- Magic Internet is focused on Magic Wormhole, Magic Cap
- Building basic tools the internet needs but no one will fund 
    - eg. [libsodium](https://doc.libsodium.org/) is an implementation of the [NaCL](https://nacl.cr.yp.to/) protocols.
    - Another comparable: [libssl](https://github.com/openbsd/src/blob/master/lib/libssl/ssl_lib.c).
        - but easier to use, like https://github.com/mendsley/libssl

- Magic Cap is "data capabilities" (inspired by OCap) - library for decentralized capabilities. (Networking, Permissions, Persistence)
    - Rust for interop 
    - Python bindings (because we love python)
    - Wasm for browsers (eg JavaScript, NodeJS)
- Client-first
- eg. "am I allowed to change these bytes?" 
    - Today: enforced by Linux
    - Next: enforced by linux, determined by MagicCap
- Independent of a server or provider.
- Budgeting and roles, TBA
- Public infrastructure and assets, Real Soon Now.

#### FAQs
- Is there a community meeting or some other way to follow Magic Cap?
    - Not Yet. TBD.
- Is Magic Cap a re-write of Tahoe-LAFS?
    - No. Think of it as smalltalk on crack.
- Are we making an oCap system?
    - No. The libraries should include 
- What if I want to use Spritely goblins?
    - Magic Cap could work with Spritely.
- Do we know what the boundary of the API looks like (Files? AuthZ Permissions? Directories?). What level of abstraction would the libraries operate?
    - TBD, but we'll avoid leaking some of the abstractions we have leaked in the past.


#### Getting steeped in Rust
- Chris wants to align his work on the Rust LAFS crate.
- Wormhole Rust implementation has fallen behind.

### Other links:
Brian on Magic Wormhole:  https://www.youtube.com/watch?v=sulJG196BMw
    -  Longer talk: https://www.youtube.com/watch?v=oFrTqQw0_3c
-  Learn Rust with practical excercises: https://rustplatform.com/ 
-  https://gitlab.redox-os.org/redox-os/cookbook
-  https://blog.bovid.space/conceptual-intro-to-spritely-goblins.html
-  https://en.wikipedia.org/wiki/Object-capability_model
-  The [Cosmos SDK](https://docs.cosmos.network/main/learn/advanced/ocap)
-  Carbonado is an archival format for encrypted, durable, compressed, provably 
cated consensus-critical data, without need for a blockchain or powerful hardware. https://crates.io/crates/carbonado


## Jan 21, 2025

### Attendees
- Blaise
- Chris
- Flo (@hacklschorsch)
- Jeff 
- Meejah

#### Chris: Rust implementation
- Erasure, mutables...
- Meejah asked about the fec crate

#### Flo: New PubGrid online
- New PubGrid online
  - Couldn't keep old introducer fURL because of lost key, new fURL is in https://tahoe-lafs.org/trac/tahoe-lafs/wiki/TestGrid
- [Updates](https://github.com/tahoe-lafs/infrastructure/pull/6) merged into `main` branch of [IaaC repository](https://github.com/tahoe-lafs/infrastructure/)
- Many improvement ideas already in https://github.com/tahoe-lafs/infrastructure/issues
  - These tickets should be in Trac instead
 
#### Flo: Debian packages accepted
- Great work from Andrius (maintainer for Debian packages)
- Tahoe-LAFS incl. 8 (?) new dependencies have been accepted into Debian Testing!  This means we'll make it into the upcoming Debian release (and all downstream distros, see, for example, https://repology.org/project/tahoe-lafs/versions)
- All tests pass with Python 3.12 and 3.13
- Our code is continuously tested against packaging and Debian version of dependencies in https://github.com/tahoe-lafs/tahoe-lafs/pull/1426, to be merged
- Cosmetic fixes ongoing regarding SyntaxWarnings of Python 3.12/3.13

#### Flo: Tahoe-LAFS mobile app
* Own grid functionality completed
* Working on parsing plain Tahoe-LAFS Dircaps
* Have [improved architecture of application](https://gitlab.com/tahoe-lafs/tahoe-lafs-mobile/-/merge_requests/29)
* Test version going Play store

#### Private Facts sample app

Decisions
* example with key:values (write direct to Tahoe?)
* example with sqlite (cache locally, save to Tahoe on exit)

For simple pure tahoe, do the key:value

Error Handling
* examples at https://github.com/tahoe-lafs/magic-folder/blob/main/src/magic_folder/tahoe_client.py
* Chris: check if the tahoe node is running vs a failure in transmission (eg. we got a connection refused error, is the node running? or is there a problem like a happiness quota)
* [`get_welcome`](https://github.com/tahoe-lafs/magic-folder/blob/993f1ab478ca073c594b16973984ba485d9575d5/src/magic_folder/tahoe_client.py#L186) is the key to happiness


#### Fedora packaging

* they are having trouble with the python package: https://copr.fedorainfracloud.org/coprs/g/fedora-review/fedora-review-2327756-python-magic-wormhole/build/8295435/
* Some consider the Rust implementation to be more current
* 
---

## Jan 14, 2025

### Attendees
- Blaise
- Chris
- Flo (@hacklschorsch)
- Jeff
- Meejah
- Pete

### Test Grid in progress!!

- Change the dnd records
- Decide the lifecycle of files, 
- expiration
- governance (manage the introducers?)

### Private Facts
Blaise gave a tour of the latest description of the sample application: 
- using the Sphinx theme: https://github.com/pradyunsg/furo
- ADR: use the `requests` library for the python examples
- ADR: use sqlite for the "database"
- ADR: use fastAPI for the app server
- ADR: handle the "directory/filepath" metaphor later

#### Decisions

- Impose the file system metaphor later?
- Use the test grid?

### Roadmap: Tahoe Enhancement Proposal process. What work is the project likely to prioritize?
As funding for the current work comes to an end, what are we working on and what are the Project priorities?
What would most benefit the project?
- Chris working on Rust implementation (does it have a future?)
- Blaise working on project adoption (use cases, office hours, conferences, example apps)
- Interoperability with other technologies


## Jan 7, 2025
### Attendees
- Blaise
- Ben
- Chris
- Flo
- Jeff
- Meejah
- Shane
- Sherry

We exceeded the jitsi capacity. It struggled to handle the size of the meeting!

#### Welcome Sherry


## Dec 17, 2024
### Attendees
- Blaise
- Flo
- Jeff
- Meejah



### Previous Items

#### CI is mostly green:
- https://github.com/LeastAuthority/tahoe-lafs/tree/3484.test-build-images
- https://github.com/LeastAuthority/tahoe-lafs/tree/4143.refresh-images-part2
- 

### New Items

#### 3rd party Integrations
- Rodrigo has some scaffolding for a app using svelte.js in the repo for the sample app: https://github.com/blaisep/private_facts/blob/main/packages/src/routes/dashboard/%2Bpage.server.js

#### Writing design docs
@meejah:
- Describe the characteristics of:
    - Grid
        - Protocols (GBS, foolscap, both)
        - storage criteria
    - Introducer
        - member criteria
        - service discovery
        - announcements
    - Membrane
- Examples:
    - https://github.com/tahoe-lafs/tahoe-lafs/blob/master/docs/managed-grid.rst
    - https://github.com/tahoe-lafs/tahoe-lafs/blob/master/docs/specifications/http-storage-node-protocol.rst

Need not be an implementation guide. It could be prose or something more structured, such as:
- https://github.com/balanced/balanced-api/blob/master/features/callbacks.feature
- https://github.com/behave/behave/blob/main/features/fixture.feature
- https://github.com/balanced/balanced-api/blob/master/features/settlements.feature

## Dec 10, 2024
### Attendees
- Ben
- Blaise
- Chris
- Jeff
- Meejah
- Shane

### New Items

#### CI
- Ben has CI working everywhere 
    - Github
    - Local
    - Backport changes to CircleCI
    - **Except**: Inconsistency specific to Circle CI (even in Least Authority Org), possibly resource related on circle CI's k8s config
- Trac issues
    - 3484
    - 4131
    - 4135
    - 4142
    - 4143 (Updating the CI images)
    - xxxx (Using the new images)
    - xxxx (_Plan B_ bypassing the intermediate image build)

Note: Tahoe-lafs github admin group has 6 members.

#### Is building CI images in advance a premature optimization?
- Circle CI creates "tahoelafsci/debian:11-py3.9" and uses that image to create the build.
- It requires a periodical "click of the button" for the occasional rebuild of the CI images.
- It does not actually provide reproducible builds.
- We are not pinning images nor are we pinning wheels.
- It *may* provide some faster builds (we have not quantified)
- Reporoducibility vs (...) Currency (?)
- @blaise: We should consider a separate repo/pipeline for CI images because their revision cycle is different from Tahoe-lafs
- @meejah: there is not a lot of project or version specific code added to the docker images.
- @meejah: I don't want to run ci against a previous frozen version. I want to run CI against the current version.
- @meejah: useful to pull the latest platform, maybe pin the python.
- @ben: we can fix what we currently have (the Dockerfile infrastructure) and consider making changes separately.
- Ben will explore a PR building with the upstream images without the intermediate docker images.

#### Consider pinning Python separately from platform

- cache and pin the platform? (criteria?)
- cache and pin the Python? (criteria?)



## Dec 3, 2024
### Attendees
- Ben
- Blaise
- Flo
- Shane
- Meejah
- Chris
- Jeff


#### We need a release, soon
@hacklschorsch 

#### CI failures
- @btology happy to migrate CI off CircleCI (we chose Circle for reliability, but that has changed)
    - has a plan to move most of the unit tests [which currently fail on CircleCI](https://github.com/LeastAuthority/tahoe-lafs/actions/runs/12144760020/job/33864884211) over.
    - Todo: Update fedora builder to fc41
- Typecheck fails on `master` https://tahoe-lafs.org/trac/tahoe-lafs/ticket/4115
- Oracle Linux fails: https://tahoe-lafs.org/trac/tahoe-lafs/ticket/4135
- Master branch does not build
    - Integration tests do not run on master branch 
- Nix pacakge build does not work
    - Too Slow:https://tahoe-lafs.org/trac/tahoe-lafs/ticket/4126)
    - Cachix does not have current images, so dependencies must be built from source. 
    - We need Cachix token [trac](https://tahoe-lafs.org/trac/tahoe-lafs/ticket/4134)
    - We need access to the Cachix org to regnerate the token
    - Do we care about nix?
        - If someone needs the flake for Tahoe-lafs, eg (private storage?) they will fail.
        - Maybe we consider that "downstream" and people can fix it.
- PyPi: ownership for prod, but only JP has access to test.pypi
- Ubuntu builder fails https://tahoe-lafs.org/trac/tahoe-lafs/ticket/3949
- We build wheels for Windows, Mac OS, Debian and PyPI
- Should we decide which CI are "blockers"?
    - Debian, Mac OS and Windows MUST be green
    - If no one complains, then they dont block


## Nov 26, 2024
### Attendees

- Ben
- Blaise
- Flo
- Shane
- Meejah
- Chris

### New Items:

#### Tahoe Project open office hours
- Consider a standing schedule for folks to drop in with questions and pairing.
- Blaise is available to turn on the lights, start the coffee pot and arrange the chairs.
- Meejah suggests 15:00 UTC might be a good time for Europe and North America.

#### GridSync

[Standalone magic-folder binaries fail due to missing win32com.shell import](https://github.com/gridsync/gridsync/issues/707)
[PyInstaller/frozen tahoe executables fail to execute on macOS 13 due to missing libintl](https://github.com/gridsync/gridsync/issues/709)

#### User Stories for Landing  Page: www.tahoe-lafs.com (and related Wiki content)
- Describe the CRUD lifecycle
    - Who does the CRUD ?
    - What privs do they need?
- Failure Scenarios:
    - Host outages? (no response from host, page not found, ...)
    - Content bugs? ()
@hacklschorsch wants :
    - static landing page sounds good
    - enough redirect to preserve the original trac urls https://docs.gitlab.com/ee/user/project/pages/redirects.html
    
    
- Wiki Pages are mostly reproducible
    - Before:
        - https://tahoe-lafs.org/trac/tahoe-lafs/ticket/4095
    - After:
        - https://forge.lafs.eval.latfa.net/tahoe-lafs/trac/issues/4095
    - NOT reproducible:
        - dynamic(ish) content like Roadmap, 


#### Broken CI updates

- CircleCI keeps asking for an SSH key in some fork or PR!?
- Flo thinks he has fixed most of CI issue,
- but there is still a flaky systemtest which fails from time to time
- Ben is trying to reproduce this flay part with GH actions

- Refactor (big) tests, see https://tahoe-lafs.org/trac/tahoe-lafs/ticket/4078 and then https://github.com/tahoe-lafs/tahoe-lafs/pull/1354
    - Tracebacks get elided through Twisted, tracebacks get created at the deferred, yet we want them created from where they are deferred. ( [because](https://github.com/tahoe-lafs/tahoe-lafs/pull/1354/files#r1444822971) )
    - @meejah: "The real problem may be that we're shutting it down too many times" and it does things after it has been stopped (eg. Add shares called after we deleted Shares)
    - Differing seeds for random number generators can result in strange behaviour so @Chris points out that we can force `PYTHONHASHSEED=1` and force consistency.

#### FOSDEM 2025

- Flo and Ben would like to present some works (e.g.: Mobile, Tracker, Website),


## Nov 19, 2024
### Attendees

- Blaise
- Rodrigo
- Meejah
- Chris
- Jeff
- @hacklschorsch 
- Shane

### New Items:

#### User stories for ticketing system
Meejah and Blaise have paired on the "admin" side user stories (e.g.: "as an admin, I do not expect to require access to the underlying host" eg. system upgrade, system users, etc.)

#### SupaWiki and Tahoe for private content.

- Describe the threat model. Be clear on the expectations resulting from the specific deployment mode.
For example, with Desktop apps there is "Trust on every use" so it is "less secure" than locally installed code.

@rodrigo explained that it is possible to conserve the principles in Tahoe. He had to read a lot to understand where the edges are and what he would need to implement in order to take advantage of the security model.

@meejah: Let's pretend we have an available grid. Where would we keep the capability string, how would a patient expose data to the doctor?
- Prefer the term "exposure" over trust. There is no trust in tahoe, just exposure.

@Rodrigoplp: we dont' yet have specific constraints, because we're exploring an example (the private medical facts)
- The work that needs to be done is to make clear where the exposure begins.
- If the system requires many nuanced decisions, then it will be used by experts
- If you need to access simple users, then they need apps that have few dials and levers

@chris: tahoe doesn't have a security guarantee beyond the capability string, so sharing and recovery would need to be addressed by an external tool.

@meejah: well, there is a `membrane` cap that provides a short lived string. Tahoe has been conservative about claims, which is why there is no delete key.

*Questions*
- if an app can add a layer of access control, *then* it can facilitate sharing, revocation and recovery?
- should we add glossary entries for terms like `exposure` vs `trust`

### Todos:
- Explicit doc for the "security model" (inclusive of:
    -  https://tahoe-lafs.readthedocs.io/en/latest/architecture.html#security
    -  https://tahoe-lafs.readthedocs.io/en/latest/about-tahoe.html#what-is-provider-independent-security (ie.  The "provider-independent security" doc)
- Expand glossary entries to include security concerns (eg. "treat capability strings as secrets", or the "secure domain is where the cap string is in the clear")
- Add Glossary entries:
    - exposure
    - trust
    - sharing
    - revocation
    - recovery
    - membrane
    - macaroon


#### Broken CI

@hacklschorsch : the tests seem to fail around HTTP. Foolscap seems to work but HTTP will pass and then fail.
https://github.com/tahoe-lafs/tahoe-lafs/pull/1381#issuecomment-2444698978
(maybe improve setup and teardown? see: allmydata.test.test_system.HTTPSystemTest )

Ben noticed that there are less failures on the PAID circle CI account?!
Ben will try to verify this using the LA fork:
https://github.com/LeastAuthority/tahoe-lafs/tree/master, which now fails on CircleCI because of this ghost SSH key issue.

### Beware logging
There are several log sources and they are joined (manually) using timestamps :frowning: 
- Eliot  (`eliot tree`, `eliot prettyprint`)
- Twisted
- Python logger

#### FOSDEM 25 in Bruxelles ?
- Should we present a talk here?


## Nov 12, 2024
### Attendees

- Ben
- hacklschorsch
- Jeff
- Rodrigo
- Shane
- Blaise (late)

### New Items:

#### SupaWiki https://supawiki.com/
Rodrigo joined and presented the idea to record personal data in a safe/private wiki.

Update from blaise, limited availability during mourning:

Public Repo for the integration app is: https://github.com/blaisep/private_facts 
@rodrigoplp is blasting ahead with integration into supawiki.com 

#### Mobile Tahoe-LFS mobile app in Haskell
Good news, a few PRs have been merged: 11, 14, 15, 17, 19, 20 and 21:
https://gitlab.com/tahoe-lafs/tahoe-lafs-mobile/-/merge_requests/?scope=all&state=merged

#### User stories for Tahoe-LAFS end-users:
Jeff and Blaise are working on describing how Tahoe-LAFS works.
Leading to a sequence diagram (WiP):
https://github.com/blaisep/private_facts/blob/main/docs/source/upload_content.puml

#### MoveOffTrac
- Pairing meeting on user stories postponed.
- Possible licensing issue discussed with Codeberg. In short, if this is dual-licenced project, it should not be an issue.
- The problem could come from [TGPPL](https://github.com/tahoe-lafs/tahoe-lafs/blob/master/COPYING.TGPPL.rst) and CodeBerg [policy](https://docs.codeberg.org/getting-started/faq/#can-i-host-software-and-resources-without-a-free-and-open-source-software-license%3F)
- Ben needs more info from Meejah and Pete to try to get a written approval from Codeberg.
- As a reminder: this is not a blocker, until we decide to move the code from GH to CodeBerg (not in scope so far).

#### CircleCI
- Ben is working on the SSH ghost key issue
- More info in [#4098](https://tahoe-lafs.org/trac/tahoe-lafs/ticket/4098#comment:17)
- The problem may be fixed in 2 ways:
  1. gaining admin access (using a temporary GH user) to add and remove an ssh key (hopefully cleaning the dirt in the pipes)
  2. forcing https checkout using a custom step (PR in progress)
- Rodrigo said it may be worthed to consider alternatives to CircleCI, like an independent version of GitHub Actions.
- As a reminder: the CI is already half GH, half CircleCI. But if GH is doing better, both look vendor locking.
- Some steps have been made in the MoveOffTrac to test Gitea act runner, which is a replacement for GitHub actions: https://code.lafs.eval.latfa.net/tahoe-lafs/web-landing-page/src/branch/main/.gitea/workflows/jekyll.yaml


#### Other links:
https://yopass.se/   (Maybe uses Tahoe?)
https://github.com/tahoe-lafs/tahoe-lafs/blob/master/COPYING.TGPPL.rst


---

## Nov 05, 2024
### Attendees

- Ben
- Blaise
- Chris
- hacklschorsch
- Jeff
- Meejah
- Shane


### New Items:

#### Project Adoption
The creator of [SupaWiki](https://supawiki.com) is interested in being able to create and read private objects using Tahoe.

@blaisep :  created a fresh repo to hold code for the Tahoe-specific demo app, inspired by the meetup-health tracker: [private_facts](https://github.com/blaisep/private_facts). Happy to add collaborators.

### Ongoing

#### Trac migration with keywords
[PR](https://github.com/tahoe-lafs/trac2gitea/pull/31) in progress for trac2gitea to migrate keywords as labels (total = 912 w/ some dupplicates).

Let's meet offline to review https://tahoe-lafs.org/trac/tahoe-lafs/ticket/4095 and memorialize a decision process.
- summarize the user scenarios ([stories](https://github.com/tahoe-lafs/MoveOffTrac/blob/main/docs/UserStories.md))
- clarify the constraints and requirements
- clarify the scope of each milestone (eg. describe structure of an issue, choose. a target pla)

#### CircleCI
- Making progress in related repositories (e.g.: ZKAPAuthorizer) and learning for Tahoe-LAFS
- ssh key error seen in many projects, inluding Tahoe-LAFS: WiP to understand/avoid it
- Too much permissions by default

#### RClone
- https://forum.rclone.org/t/tahoe-lafs-backend/6625
- Flo: Very interesting! The REST API looks perfect for rclone - there are many rclone backends which work in a very similar way so that would be easy for rclone to consume. 

#### Python packaging
- Is there a more "standard way" of packaging Python (Ben found it heterogeneous)?
- Blaise and Jeff are investigation [UV](https://github.com/astral-sh/uv): promessing, but?
- Tahoe-LAFS still uses [Makefile](https://github.com/tahoe-lafs/magic-folder/blob/main/Makefile)!
- Note: Tahoe-LAFS packages are not deployed to PyPi from CI
- BTW: PyPi is about to drop signature w/o alternative
- Meejah still publishes signatures for other projects
- See https://github.com/meejah/pypiratzzi/

---

## Oct 29, 2024
### Attendees

- Ben
- Blaise
- Chris
- hacklschorsch
- Pete
- Jeff
- Meejah
- Shane


### New Items:

#### CodeBerg has some retrictions about the license
- https://codeberg.org/Codeberg/org/src/branch/main/TermsOfUse.md#2-allowed-content-usage
- Re-licensing does not look like an option for Tahoe-LAFS (TGPPL)
- This is a cons, but there are other Forgejo providers

#### Magic-grid installation is fixed (Meejah)
A simple typo in `pyproject.toml` resulted in ugly traceback. https://paste.ofcode.org/wapHcem8hXBVgigJ8LQUFg

#### Explosion of interest in the Health app
Front end developers from the Nivenly community (folks behind https://hachyderm.io ) are excited about a health tracker with provider-independent privacy.

#### Jeff working on 1101
Writing tests for a CLI improvement (handling the `--verbose` option for commands that don't explicitly support it). @meejah suggests starting with `tahoe ls` because it lacks `--verbose` and is very simple.
    - The Twisted CLI test infrastructure is weak.
    - The way the Twisted handles cmd args is somewhat magical.
    - Ideally, we re-write the CLI with `click` ... :santa: 

#### Learning to run individual tests:

[tox.ini](https://github.com/tahoe-lafs/tahoe-lafs/blob/master/tox.ini#L76) has most of the details. In general, most of the tests use Twisted's trial module. Use `python -m twisted.trial --help` 

#### Help is on the way for CI.

B3n reports that there is approval for applying some of his time to work on CI.

#### something about SEEDS proposal
??

#### Maybe release a new Magic-Folder
    - conflict-resolution branch may be messy.
    - Chris might benefit for grid-sync
    - The Tahoe client UI for Magic Folder is ... not smooth because it shows the various levels and metadata..
    
#### Case Study: Bootstrap WireGuard using magic wormhole
- One time use of magic wormhole to set up or add a wireGuard node. @meejah

#### trac2gitea keywords
- https://github.com/tahoe-lafs/trac2gitea/issues/28
- ticket keywords would generate 1846 new labels
- Meejah suggested to look at https://github.com/twisted/twisted which had similar concern (e.g: #11563)

### Related links:

[STUN tunneling](https://github.com/magic-wormhole/magic-wormhole/issues/6#issuecomment-147854595)

## Oct 22, 2024
### Attendees

- Blaise
- Chris
- hacklschorsch
- Meejah


### New Items:
#### Debian build
Is there a set of tools we can use to validate our Debian builds?
#### Decision: let's avoid including Debian-specific dependencies in upstream.


#### Python 3.13
Jeff noticed a weird error with 3.13.rc2: https://tahoe-lafs.org/trac/tahoe-lafs/ticket/4118#comment:4
Chris is checking compatiblity. 3.13 deprecated `cgi` module and there are dependencies on it.
#### Decision: We should move cgi classes to use the Twisted APIs

#### Testing NAT with pytest and libvirt Virtual Networking
@meejah : testing NAT with pytest is a headache
@blaisep : consider one of the networking emulation libraries like [pygmni](https://karneliuk.com/2021/08/pygnmi-10-rapid-and-reliable-network-testing-with-pytest-pygnmi-and-openconfig/)
@chris : `headscale` is a open source tailscale/wireguard to VPN all-the-things (orthogonal, but interesting)
https://archive.fosdem.org/2023/schedule/event/goheadscale/

---

## Oct 15, 2024
### Attendees

- Blaise
- B3n
- Meejah
- Jeff
- Chris


### random notes

- some discussion of security etc around Terraform-managed Gandi DNS 
- some meta-discussion of privacy of data for some use-cases
- distributed forgejo (etc) PRs mentioned, discussed a bit
- blocker: CI not working https://github.com/tahoe-lafs/tahoe-lafs/pull/1377
- Contributor/Developer [step-by-step guide](https://tahoe-lafs.org/trac/tahoe-lafs/ticket/4118)
- It would be good to have a good solution for "oops, I merged the wrong commit" scenario. [trac](https://tahoe-lafs.org/trac/tahoe-lafs/ticket/4124#ticket)
- Twisted project used https://github.com/chevah/trac-to-github to migrate from trac to github

#### Decisions: 
- convert legacy keywords to static labels
- link to stored queries that contributors can reuse.
- Become independent of [CircleCI](https://sr.ht/~meejah/magic-grid/) is an aspiration. Some brave soul should do it.
- we'll need CircleCI until we can make CI run on the three platforms: Linux, Windows, Mac.
- Look at using [magic grid](https://sr.ht/~meejah/magic-grid/) to automate the tutorials

### [Issue Tracking](https://github.com/tahoe-lafs/MoveOffTrac/blob/main/docs/UserStories.md)
@b3n and @blaisep: Writing the [user stories](https://github.com/tahoe-lafs/MoveOffTrac/blob/main/docs/UserStories.md) for issue tracking revealed some scenarios we had not considered. The team should discuss the alternative and consequences.
We learned:
- There are additional, distinct,  roles with associated privileges and activities.
- Many issues are associated with each other using the free text `keywords` feature, which is not covered by the current migration.
- Ticket Discovery: The View Ticket page has many pre-defined queries which have no direct counterpart outside of trac.

### Related links:
- [Git Federation](https://drewdevault.com/2018/07/23/Git-is-already-distributed.html)
- [Git over ActivityPub](https://forgefed.org/)



### Gaps in the [Contributor guides](https://tahoe-lafs.org/trac/tahoe-lafs/ticket/4118)
A new contributor has no clear path to a usable PR. The instructions assume familiarity with the project. For example:
- A contributor cannot find related tickets (WIP, previous solutions, dependencies, @meejah's tutorial automation ticket)
- How to collaborate on tickets that relate to each other?
- CI/CD: Which commands build the project?
- ...It happens that Tox is the the entry point to CI (meejah: not really, but yes tox can run _some_ of the different environments a contributor would want)
- When to use the various Tox targets?
- The instructions for a PR should include everything that a contributor needs for sucessful review (ie. reviewer should not have to run additional tests). (meejah: current best effort here is probably https://github.com/tahoe-lafs/tahoe-lafs/blob/master/CONTRIBUTORS.rst)

### QUESTIONS: current contributor user stories
- As a current contributor, when you want to find a ticket in Trac, do you:
    - Use a prepared query on the [View Ticket](https://tahoe-lafs.org/trac/tahoe-lafs/wiki/ViewTickets) page?
    - Use the Custom query form?
    - Follow links inside an existing issue?



---

## Oct 8, 2024
### Attendees

- Blaise
- B3n
- Chris
- hacklschorsch
- ccx
- Jeffhimself


### New Items


Include tests in the description of an issue.
- https://tahoe-lafs.org/trac/tahoe-lafs/ticket/2050#comment:7

Proposed Docs config changes
    - create
        - docs/test (to store the docs-specific tests)
        - docs/source (to restrict Sphinx to the the docs content, exclude tests, etc.)
    - add sys.path to docs/source/conf.py (to find the source directory)
    - Makefile (run Sphinx against the source directory)
    - Makefile doc-testing (add target for `make doc-testing`)


#### The step-by-step Developer Guide
A failing test(s) for being ready to
- build docs (`tox -e docs` ?)
- run the tests?
- submit a PR (nothing broken that the author couldnt' check themselves)
- build a release

#### Trac migration Developer Experience
- @ccx Search? Associating trac issues to a feature is a PITA (labels, components are migrated)
- @chris: developers should be able to see CI results; what is the integration of issue/commit/PR
- @blaisep : reorder commits to match their tests.
- Codeberg CI https://codeberg.org/Codeberg-CI/woodpecker

### Questions
- How does tox know about the fixtures?
- setup.py install returns:
`error: The 'zope-interface>=5' distribution was not found and is required by Twisted, twisted
` (and I'm not supposed to run setup.py)

---

## Oct 1, 2024
### Attendees

- Blaise
- B3n
- Chris
- hacklschorsch
- Jeffhimself
- Meejah
- Pete

### New Items:

- Release Checklist, simple PR edition?
- Public Grid?
- Public mailbox server? (MagicFolder)
- Fowl and Dilation mentioned as unannounced apps related to file transfers


#### Trac Migration docs
- WIP https://github.com/tahoe-lafs/MoveOffTrac/tree/docs-update-24w40/docs
- Docs tickets will serve as the initial spike to test new user (Blaisep) creation.
- User Account management has some cases we want to excercise (forgot password, account confirmation, etc)
- Redirecting legacy URLs to the new issue tracker.

### Prior Items:

- Debian packaging in progress (@hacklschorsch will ask Debian Tahoe-LAFS maintainer about status, if we can help, and whether/what dependencies are currently missing in Debian)
- fixed cryptography library issue https://tahoe-lafs.org/trac/tahoe-lafs/ticket/4100#no1

#### Dependency management

- "Tahoe is an app, so we shouldn't pin dependencies" @pete

#### related projects
- "Git with you": Peer to Peer git colab (not via github) using pairon (?)
- [Dulwich](https://www.dulwich.io/docs/#getting-started) is a python implementation of git
- https://meejah.ca/blog/wizard-gardens-vision
- [Copybin](https://carml.readthedocs.io/en/latest/command-copybin.html), but private
- https://magic-folder.readthedocs.io/en/latest/invites.html#invites
- Brian's STUN server (?)
- @pete mentioned research on [OCAP](https://github.com/ocapn/ocapn)s over [CRDT](https://github.com/alangibson/awesome-crdt)s
- exposing ssh using [Inlets sshmux](https://inlets.dev/blog/2024/02/05/access-all-your-ssh-servers-with-sshmux.html)
- https://www.wireguard.com/
- [ZCAP](https://w3c-ccg.github.io/zcap-spec/) is separate from Tahoe. [Github]()


---


## Sep 24, 2024
### Attendees

- Blaise
- B3n
- Chris
- hacklschorsch
- Jeffhimself
- Meejah
- Pete

### New Items:

- The new tutorials and docs will default to systemd in examples for running as a service.
- We'll start migrating issues. @b3n will provide a summarized plan next week. If necessary, we'll migrate to a self-hosted forgejo instanc.

#### Migration: User Management topics
- Account creation flow
    - Auto-registration OFF, 
    - User Creation
        - Auto create if Github auth'd
        - Manual 
- Forgotten password flow (eg. Github IdP is down)

#### Tahoe-S3
- A client which maps the finger tree into S3 numbers (and deal with S3 size limits)
- Finger tree used to handle failure scenarios
- Immutables only
- Doesn't create the shares
- Doesn't replace the native Tahoe storage server
- A challenge to implement in Haskell because it requires intimate knowledge of Tahoe internals, REST and Foolscap APIs

#### ADR: Tech stack decisions
- Whither Haskell?
    - How much functionality is already implemented?
    - Haskell is a good high-level language.
- Whither Rust?
    - If we build *low-level* components in Rust, there's opportunity for re-use.
    - Rust has lots of tooling 

#### Improving Immutables
- Single block writers are the problem (@ccx)
- blockless multi-writer implementation is the answer

Speaking of block storage, @blaisep wonders if [k8s longhorn](https://longhorn.io/docs/1.7.1/references/longhorn-client-python/) integration may be a crowd pleaser.


## TILs

- Duplicity has a backend option [`--tahoe`](https://fossies.org/linux/duplicity/duplicity/backends/tahoebackend.py)
- Python pre-compiled for [iOS](https://github.com/PyO3/maturin/issues/1742#issuecomment-1686219705), courtesy of [maturin](https://www.maturin.rs/tutorial)
- Room for improvement in describing our goals, roadmap milestones, features, etc. ("implement Tahoe-S3" vs "have a phone app")


---

## Sep 17, 2024
### Attendees

- Blaise
- B3n
- Pete

### New Items:

#### Trac migration
The time has come. @b3n requests that next week we set in motion the steps to leave trac and use .... something else. (Eventually, we may use GitHub, but before we can migrate to GitHub we need to clean up the issue data anyway).

#### Provisioning and configuration management
On a ddifferent note, most of the meeting was a discussion comparing provisioning and config management tools. @pete has a project where he needs to produce packaged images for various distributions. Ultimately, the images will run containerized applications.
This is an area with too many choices.

Some of the resources that came up in the discussion may be interesting to others:
- [DeBock's Ansible Roles](https://robertdebock.nl/ansible.html#roles). These are tested, [using molecule](https://ansible.readthedocs.io/projects/molecule/), against several Linux distos and versions.
- [Packer](https://www.packer.io/) from HashiCorp, takes the "images as code" approach. Concerns about a terraform-style licensing issue came up.
- [Distrobox](https://distrobox.it/) to create containers with custom configurations.
- [Toolbx](https://containertoolbx.org/) is a wrapper for [podman](https://docs.podman.io/en/latest/) and can be considered as a simpler [alternative to distrobox](https://discussion.fedoraproject.org/t/thread-about-switching-to-distrobox/89151/18?page=2)
- Finally, the consensus is to create a `justfile` using [Just](https://just.systems/man/en/) to control the tasks and invoke tools like packer and ansible when necessary. Also, consider the trick that the [Fedora Atomic Desktop](https://getaurora.dev/) use to alias `ujust` to point to [admin-provided tools](https://universal-blue.discourse.group/t/just-reorganization-part-1-released/417#automation-and-scripting-3).
- We agreed that [dagger engine](https://docs.dagger.io/quickstart/#topics) would be useful for interacting with the running containers, but this was out of scope.

---

## Sep 10, 2024
### Attendees

- Blaise
- hacklschorsch
- Chris
- Ccx

### Step-by-step approach to getting started
Instead of [showing everything at once](https://imgflip.com/i/930yve), build up the service one feature at a time. @blaisep  has Incoming PR for https://tahoe-lafs.org/trac/tahoe-lafs/ticket/4103


### Express modularity using C4 notation for the diagrams
- layers of abstraction Context, Container, Component, Code
- [PlantUML includes](https://crashedmind.github.io/PlantUMLHitchhikersGuide/) C4 in the std lib
- https://crashedmind.github.io/PlantUMLHitchhikersGuide/C4/C4Stdlib.html

### Describing Tahoe to local user groups
As prep for presenting to larger conferences
@blaisep offers to do user group talks (later: conference presentations)
- Historical context (eg. why did they create SDK first? Surveillance capitalism, enshitification, etc.)
- Use case examples (creating examples relevant to end users)
    - The "dumb pipe scenario" (provider-independent security), use cloud storage for personal data. 
    - Storage only is low value

#### Challenges
Either gaps in functionality or gaps in understanding
- Describing the security boundaries (eg.vs corp walled gardens)
- Key management, rotattion, revocation
- The "dumb pipe scenario" (provider-independent security), use cloud storage for personal data. 
- No generic writer( @ccx ) can't write everything to/from everywhere.

#### Comparisons
Describing Tahoe in terms of something they already know.
- Nostr:  @chris has written some [Nostr](https://nostr.org/) bots. It's not a dumb pipe in a security sense. It's meant to be censorship-resistance, not confidentiality. More of a brute force approach vs lots of cryptography. @hacklschorsch liked the way the Nostr delivery model (push data to your favorite relay...) is presented.
Flo said NIP-104 will be a big improvement for private messaging 
https://github.com/nostr-protocol/nips/pull/1427
 
- IPFS: similar layer of abstraction. More client implementations. Scales differently? https://news.ycombinator.com/item?id=37750529
- Signal: but for storage ( _can Signal self host?_ ) The reference implementation is a useful app, SDKs, Open protocol, ubiquitous.
- Syncthing: (peer-to-peer) but with decentralization and capabilities (@ccx)

---

## Sep 3, 2024
### Attendees

- b3n
- Blaise
- hacklschorsch
- Meejah
- Ccx


## Prior Items

- Glossary items

- Debian packaging maybe delayed because `pycddl` has never been packaged for Debian. We might make it in by the end of the year. @hacklschorsch 
    - (we should check if any of our other dependencies have never been packaged for Debian @meejah)

- Trac migration (see: https://tahoe-lafs.org/trac/tahoe-lafs/wiki/MoveOffTrac#ProsandConsofself-hostedvsSaaS) looking at the results of migration, @b3n noticed a number of issues with author attribution and broken reference links.
  - @b3n suggests that we consider a transition period where we run selfhosted and collaborate on the issues we care to migrate. (eg. the user creation needs to be automatic, yet if we set it to auto, then we also get junk accounts created) We can choose a threshold of noise and migrate or wait until it is perfect.
  - "Our trac instance has defferred maintenance and accummulated cruft over the years. The community wants to retain the option to selfhost, even if we choose not to. So if it makes sense to self host, then we can exercise that option." @meejah

- @hacklschorsch: Can we lower the Tahoe-LAFS merge process turnaround time?
  - Optimistic Merging / other ideas for the Tahoe-LAFS GitHub repo? to make contributing leaner/more fun
  - meejah: A PR that is green and has approvals is already merged quickly now.  If not, write on IRC
  - Currently, meejah is the only active committer in Tahoe-LAFS.  The committers agree it would be good to have more committers, but it's not an easy task. Blaise nominates ccx, but ccx does not have time right now.


## New items

- Veilid: is it real, where are the intersections?

@ccx : it's a library which bundles a number of p2p protocols. No existing app yet.

@meejah : played with ethersync and he made it do a thing. It's early and doesn't do anything yet. For instance, no one would install MagicWormhole if they couldn't do file sharing.

### Making it easier to develop on Tahoe
Separation of concerns, breaking tahoe into modules would be a good next move. @ccx (@blaise start a trac issue?)

---

## August 27, 2024
### Attendees

- b3n
- Chris
- hacklschorsch
- Meejah
- Pete

### Updates

- Flo
  - LA wants to hire a senior Haskeller to work on LAFS
  - iOS: Obsidian is still investigating the "illegal instruction" compiler/linker issue
  - Wrote some eMails back and forth with the Debian Tahoe-LAFS maintainer: Would be great if 1.20 would be clean of Python 2 code so it can be included in Debian again.  Also need to look at Debian Trixie code freeze date
  - Works with Blaise on Tahoe-LAFS docs
  - ... and would like to pair more in general
 
- Chris
  - published a Rust crate for LAFS: https://crates.io/crates/lafs  
 source repo: https://github.com/crwood/lafs
  -  Local and much faster than the Python equivalent (.25s instead of 24s on Chris' machine)
  -  It comes with Python bindings

- b3n
  - Codeberg importing issue acknowledged by them
  - Would like to discuss self-host vs. SaaS for the upcoming GitTea with Meejah

- Meejah
  - Magic Wormhole protocol work
  - FOWL Policy & Permissions API mostly done, soon to be merged & released.
  - [Pear-On](https://sr.ht/~meejah/pear-on/) should work ATM - testers welcome


## Previous items

@blaisep Now owns [17 trac tickets from the backlog](https://tahoe-lafs.org/trac/tahoe-lafs/query?owner=blaisep&status=assigned&status=new&status=reopened&id=&keywords=~&reporter=~&col=id&col=summary&col=keywords&col=reporter&col=status&col=owner&col=type&col=priority&col=milestone&col=changetime&desc=1&order=id) which are addressed in this month's effort to produce the getting started kit (docs and Artifacts)


## New Items

- Trac [#4103](https://tahoe-lafs.org/trac/tahoe-lafs/ticket/4103#ticket) is a running summary of the items related to the Getting started guide.
- Trac [4102](https://tahoe-lafs.org/trac/tahoe-lafs/ticket/4102#ticket) describes a workaround for a problem with one of the transitive dependencies (`eliotutils.py`).
- @blaisep has limited availability until Sep 30 2024


---

## August 20, 2024
### Attendees

Blaise
b3n
ccx
Chris
hacklschorsch

## Previous items

### WTF Circle CI?
* Is it broken? Maybe drop it?
* Do we have much logic in the Circle CI?
* It might be tests failing, rather than a systemic fail (credentials, dependencies, etc)
* "AMP server"? (twisted RPC framework) @ccx
* * https://app.circleci.com/pipelines/github/tahoe-lafs/tahoe-lafs/4958/workflows/d16324ae-293d-45c8-ba97-6ac39ef4cfc4
* https://app.circleci.com/pipelines/github/tahoe-lafs/tahoe-lafs/4958/workflows/d16324ae-293d-45c8-ba97-6ac39ef4cfc4/jobs/86344


### Towards a portable CI
* keep logic in the repo
* avoid huge Nix dependency (or maybe build a weekly Nix image)
* https://docs.gitlab.com/ee/ci/ci_cd_for_external_repos/github_integration.html



### Describe the build process
* add prose in the dev guide to the files in the repo describing the build (@blaise)
* update the release checklist: https://tahoe-lafs.readthedocs.io/en/latest/release-checklist.html

### Mutables, Service of Happiness
* @blaise asked where we were at with mutables...
* using mutables as single writers (eg. Tahoe backup)
* It's a big thing, eventually replace with a proper design for a multi-writer primitive
* For now, stick with readonly or Magic Folder for examples and getting started guide.
* > Mutables are not just even single-writer safe because partitions can cause rollbacks. Shouldn't be super common but it's still real world error case. @ccx

### [MoveOffTrac](https://tahoe-lafs.org/trac/tahoe-lafs/wiki/MoveOffTrac) - [#4095](https://tahoe-lafs.org/trac/tahoe-lafs/ticket/4095)
* Trac dump from last month has been migrated on the self-hosted Forgejo [instance](https://forge.lafs.eval.latfa.net/tahoe-lafs/trac-2024-07-25).
* Working on user mapping: trying to figure how to link trac users to Gitea/Forgejo users, with a mapping to the Github user if different!
* New Forgejo instance (copy/paste from Gitea) to be closer to Codeberg: https://forge.lafs.eval.latfa.net/tahoe-lafs/
* Testing migration to Codeberg with pagination bug (workaround), performance issue (deadlock error) and user mapping (unlikely possible)
* Keyoxide.org may help us to link all those account!?

## New Items 

* Blaisep has trac !!!
* TIL: Trac use "htdigest" (@meejah "i'll put a note in ~trac")

---

## August 13, 2024
### Attendees

Blaise
b3n
ccx
Chris
hacklschorsch
Pete

## Previous items

- Blaise needs a trac account to CRUD issues, for docs, etc.
- GitTea self register results in many spam accounts @b3n
- We have users on Trac and users on GitHub, sometimes the names are different. @b3n
- Trac Migration Plan [WIP](https://tahoe-lafs.org/trac/tahoe-lafs/wiki/MoveOffTrac)
- migrated Trac eval instance (https://code.lafs.eval.latfa.net/tahoe-lafs/trac-2024-05-23/issues)

## New
- Meejah might not have admin to [github.com/tahoe-lafs](https://github.com/tahoe-lafs/tahoe-lafs/pull/1370) but so far that isn't yet a problem (eg. if Circle CI creds need updating.) @blaisep 
- Consider using Google, GitHub auth for auto register CodeBerg accounts
- Consider upgrading/self hosting Trac instance (maybe it's not so bad after all) 
- Could we make trac readonly and do new work on the ["demo" instance](https://www.lafs.eval.latfa.net/) instance? 


### Migrating Issues: Goals and Constraints
- Anything off of track is better
- Github Issues are accessible, but there is risk of lock-in, enshitification
- Gitea/Forgejo/CodeBerg is future-proof (no lock-in)
- Inconsistent tribal knowledge about decisions made last year @blaisep et al.

---


## August 6, 2024
### Attendees

Blaise
b3n
Chris
ccx
hacklschorsch
meejah
Pete


Thought leaders:
Amber O'Hearn (not so much)
Larry Lessig
Brewster Kahle
Christine_Lemmer-Webber (spritely)


New Items:

Pete's foundation doc: https://docs.google.com/document/d/1MpFUUB9sX-SA6rsHpq9ZkIhrnZaG3zwzI6KJ9I0VAgE/edit

## Comparables

* https://spritely.institute/about/
* https://ocapn.org/
* https://darkcrystal.pw/ (meejah)
* ISRG https://www.abetterinternet.org/
* https://divviup.org/
* https://sans-io.readthedocs.io/


### Mission statements

"Infrastructure for Libre, gratis, private, intentional composability and sharing " @Blaise , @meejah

Device introduction @meejah

"social infrastructure tools (sharing and composability to support differrent social structures and relationships)" 
Bootstrap social relations, dependency maps.
@Chris

secure sharing with least privilege (zero trust?) @ccx
(Higher resolution, more ephemeral than app-level privs)
https://roy.marples.name/blog/posts/capsicum_vs_pledge_final_thoughts

Discoverable, "~~decentralized~~" (Autonomous?) / disconnected in nature (eg. TLS without the PKI) @Pete
Provider independent


### Community Survey

@Chris: Maybe do a poll "Should we build a Library or an application?" Right now it's the worst of both worlds. Maybe we could explore where we could get more bang; decompose into smaller building blocks may be better.
eg, decouple wire protocol from the U I.
https://sans-io.readthedocs.io/ @Pete 

Who is the audience? grandmas with photosharing? Political activists? crypto bros?

---

## July 30, 2024
### Attendees

Blaise
hacklschorsch
b3n
Chris
Pete
ccx

## Highlights:
* Project governance structure

## Agenda

### Previous topics:

* Docs PR in progress

## New Topics:
* A proposal for a governance structure (Pete)

### An endowment and governance structure

* Align the Tahoe mission with the right institutional structure.
* Similar cases:
    * The [Veillid Foundation](https://veilid.org/about-us/) is a very close analog.
    * https://www.djangoproject.com/foundation/
    * https://foundation.mozilla.org/en/who-we-are/
    * https://www.abetterinternet.org/documents/2023-ISRG-Annual-Report.pdf
    * https://www.abetterinternet.org/about/
    * https://matrix.org/foundation/about/
* Fund some dedicated project support

### Who is the community?
* Board members
* What are the activities?
* Intellectual property portfolio (trademarks, copyrights, patents)?

### Who is NOT the community?
Where has the project stalled and why?
Why do people drop in, get frustrated, and leave?
What are the blockers for adoption and how can we overcome them.

### Tahoe public resources; what could we build next?
* Public test grid ?
* ZCap servers ?

#### Other options for funding services

* https://docs.opencollective.foundation/how-it-works/fees

#### Dependent projects
GridSync (golang) ?
Magic Wormhole ?

#### Dependencies
* Twisted
* Mutables
* Python https://meta.pycqa.org/introduction.html

---

## July 23, 2024

### Attendees

Blaise
hacklschorsch
Meejah
b3n
Chris
ccx


## Highlights:
* Mutables would be a good thing for the Foundation to fund.
* The goal of [GBS](https://gitlab.com/tahoe-lafs/gbs-downloader) is to replace foolscap. Not there yet. (sucks to require a node online)
* Create project for client filesystem

## Agenda

### Previous topics:

Meejah: 
* Trac disk space restored
* Granted admin privs

hacklschorsch:
Mobile LAFS [Wiki page](https://tahoe-lafs.org/trac/tahoe-lafs/wiki/TahoeLAFSMobile) with draft description of Features and Scope.

B3n: 
Next, Trac migration path (DNS, )
Codeberg bug


### New topics:
* B3n: Prepare Trac migration operating instructions (DNS settings, etc)
* B3n: Help Meejah create Trac account (for Blaise).
* Decision: Let's try to make the single mobile code base work (hacklschorsch)
* Deep integration with the OS is not MVP  (hacklschorsch)
* [Gitlab milestones](https://gitlab.com/tahoe-lafs/tahoe-lafs-mobile/-/milestones/7#tab-issues) don't have the OS integration yet.(ccx)
* Create FUSE module for the dev environment (ccx)

## Notes:

Chris: 
* [Porting Tahoe hashlib](https://github.com/crwood/deterministic-keygen/issues/5) to Rust and found an issue:
* To do a restore with user supplied keys, if a directory is already created we get an uncoordinated error. Possible solution is to derive the cap locally.
* Curating a common set of test vectors

#### Restore scenarios
Todo: write up a description, describing permuted scenarios (Meejah, Chris)
(We need better words to describe the operations and events)

Four scenarios:
* Client failed, grid is fine
* Grid loses nodes
* Grid loses partial data
* Grid loses all data


#### Mutables
* Don't do service happiness (ccx's complaint)

Can't detect all the restore scenarios. Sometimes all the shares end up on one server :frowning: 
What is the meaning of Happiness? Happiness is just a number (Meejah)

#### Mobile
* Need to write up the description in  [Wiki page](https://tahoe-lafs.org/trac/tahoe-lafs/wiki/TahoeLAFSMobile) 
* We need to describe how much of the functionality
* Foolscap requires a node online, [GBS](https://gitlab.com/tahoe-lafs/gbs-downloader) does not
* "User defined grid" ? (ccx)
* What if we had a gridsync client (b3n)
* Deep integration with the OS is not MVP  (hacklschorsch)
* Obsidian has something called `backend` which is different.
* [Obelisk overrides](https://gitlab.com/tahoe-lafs/tahoe-lafs-mobile/-/blob/main/obelisk/haskell-overrides.nix?ref_type=heads)
* Let's have good interface definitions (ccx)
* [Gitlab repo](https://gitlab.com/tahoe-lafs/tahoe-great-black-swamp) Code 


#### File system browser? (ccx)
* Can we use the native [mobile libraries](https://emanual.github.io/Android-docs/guide/topics/providers/document-provider.html)?
* How much do we need in the GUI?
* (https://gitlab.com/tahoe-lafs/tahoe-lafs-mobile/-/blob/main/obelisk/haskell-overrides.nix?ref_type=heads)

#### Create project: Investigate FUSE File System Support (ccx)
* Read/Only native client
* Read/Only magic folder
* Read/Write Magic Folder
* Built on top of GBS downloader

---



