---
title: Tahoe LAFS - Nuts & Bolts Meetings

---

# Tahoe-LAFS - Nuts & Bolts Meetings
[Location](https://meet.jit.si/AccurateFiltersManipulateBefore)
[Legacy meeting notes](https://tahoe-lafs.org/trac/tahoe-lafs/wiki/WeeklyMeeting)

## August 27, 2024
### Attendees


## Previous items

@blaisep Now owns [17 trac tickets from the backlog](https://tahoe-lafs.org/trac/tahoe-lafs/query?owner=blaisep&status=assigned&status=new&status=reopened&id=&keywords=~&reporter=~&col=id&col=summary&col=keywords&col=reporter&col=status&col=owner&col=type&col=priority&col=milestone&col=changetime&desc=1&order=id) which are addressed in this month's effort to produce the getting started kit (docs and Artifacts)


## New Items

- Trac [#4103](https://tahoe-lafs.org/trac/tahoe-lafs/ticket/4103#ticket) is a running summary of the items related to the Getting started guide.
- Trac [4102](https://tahoe-lafs.org/trac/tahoe-lafs/ticket/4102#ticket) describes a workaround for a problem with one of the transitive dependencies (`eliotutils.py`).
- @blaisep has limited availability until Sep 30 2024


---

## August 20, 2024
### Attendees

Blaise
b3n
ccx
Chris
hacklschorsch

## Previous items

### WTF Circle CI?
* Is it broken? Maybe drop it?
* Do we have much logic in the Circle CI?
* It might be tests failing, rather than a systemic fail (credentials, dependencies, etc)
* "AMP server"? (twisted RPC framework) @ccx
* * https://app.circleci.com/pipelines/github/tahoe-lafs/tahoe-lafs/4958/workflows/d16324ae-293d-45c8-ba97-6ac39ef4cfc4
* https://app.circleci.com/pipelines/github/tahoe-lafs/tahoe-lafs/4958/workflows/d16324ae-293d-45c8-ba97-6ac39ef4cfc4/jobs/86344


### Towards a portable CI
* keep logic in the repo
* avoid huge Nix dependency (or maybe build a weekly Nix image)
* https://docs.gitlab.com/ee/ci/ci_cd_for_external_repos/github_integration.html



### Describe the build process
* add prose in the dev guide to the files in the repo describing the build (@blaise)
* update the release checklist: https://tahoe-lafs.readthedocs.io/en/latest/release-checklist.html

### Mutables, Service of Happiness
* @blaise asked where we were at with mutables...
* using mutables as single writers (eg. Tahoe backup)
* It's a big thing, eventually replace with a proper design for a multi-writer primitive
* For now, stick with readonly or Magic Folder for examples and getting started guide.
* > Mutables are not just even single-writer safe because partitions can cause rollbacks. Shouldn't be super common but it's still real world error case. @ccx

### [MoveOffTrac](https://tahoe-lafs.org/trac/tahoe-lafs/wiki/MoveOffTrac) - [#4095](https://tahoe-lafs.org/trac/tahoe-lafs/ticket/4095)
* Trac dump from last month has been migrated on the self-hosted Forgejo [instance](https://forge.lafs.eval.latfa.net/tahoe-lafs/trac-2024-07-25).
* Working on user mapping: trying to figure how to link trac users to Gitea/Forgejo users, with a mapping to the Github user if different!
* New Forgejo instance (copy/paste from Gitea) to be closer to Codeberg: https://forge.lafs.eval.latfa.net/tahoe-lafs/
* Testing migration to Codeberg with pagination bug (workaround), performance issue (deadlock error) and user mapping (unlikely possible)
* Keyoxide.org may help us to link all those account!?

## New Items 

* Blaisep has trac !!!
* TIL: Trac use "htdigest" (@meejah "i'll put a note in ~trac")

---

## August 13, 2024
### Attendees

Blaise
b3n
ccx
Chris
hacklschorsch
Pete

## Previous items

- Blaise needs a trac account to CRUD issues, for docs, etc.
- GitTea self register results in many spam accounts @b3n
- We have users on Trac and users on GitHub, sometimes the names are different. @b3n
- Trac Migration Plan [WIP](https://tahoe-lafs.org/trac/tahoe-lafs/wiki/MoveOffTrac)
- migrated Trac eval instance (https://code.lafs.eval.latfa.net/tahoe-lafs/trac-2024-05-23/issues)

## New
- Meejah might not have admin to [github.com/tahoe-lafs](https://github.com/tahoe-lafs/tahoe-lafs/pull/1370) but so far that isn't yet a problem (eg. if Circle CI creds need updating.) @blaisep 
- Consider using Google, GitHub auth for auto register CodeBerg accounts
- Consider upgrading/self hosting Trac instance (maybe it's not so bad after all) 
- Could we make trac readonly and do new work on the ["demo" instance](https://www.lafs.eval.latfa.net/) instance? 


### Migrating Issues: Goals and Constraints
- Anything off of track is better
- Github Issues are accessible, but there is risk of lock-in, enshitification
- Gitea/Forgejo/CodeBerg is future-proof (no lock-in)
- Inconsistent tribal knowledge about decisions made last year @blaisep et al.

---


## August 6, 2024
### Attendees

Blaise
b3n
Chris
ccx
hacklschorsch
meejah
Pete


Thought leaders:
Amber O'Hearn (not so much)
Larry Lessig
Brewster Kahle
Christine_Lemmer-Webber (spritely)


New Items:

Pete's foundation doc: https://docs.google.com/document/d/1MpFUUB9sX-SA6rsHpq9ZkIhrnZaG3zwzI6KJ9I0VAgE/edit

## Comparables

* https://spritely.institute/about/
* https://ocapn.org/
* https://darkcrystal.pw/ (meejah)
* ISRG https://www.abetterinternet.org/
* https://divviup.org/
* https://sans-io.readthedocs.io/


### Mission statements

"Infrastructure for Libre, gratis, private, intentional composability and sharing " @Blaise , @meejah

Device introduction @meejah

"social infrastructure tools (sharing and composability to support differrent social structures and relationships)" 
Bootstrap social relations, dependency maps.
@Chris

secure sharing with least privilege (zero trust?) @ccx
(Higher resolution, more ephemeral than app-level privs)
https://roy.marples.name/blog/posts/capsicum_vs_pledge_final_thoughts

Discoverable, "~~decentralized~~" (Autonomous?) / disconnected in nature (eg. TLS without the PKI) @Pete
Provider independent


### Community Survey

@Chris: Maybe do a poll "Should we build a Library or an application?" Right now it's the worst of both worlds. Maybe we could explore where we could get more bang; decompose into smaller building blocks may be better.
eg, decouple wire protocol from the U I.
https://sans-io.readthedocs.io/ @Pete 

Who is the audience? grandmas with photosharing? Political activists? crypto bros?

---

## July 30, 2024
### Attendees

Blaise
hacklschorsch
b3n
Chris
Pete
ccx

## Highlights:
* Project governance structure

## Agenda

### Previous topics:

* Docs PR in progress

## New Topics:
* A proposal for a governance structure (Pete)

### An endowment and governance structure

* Align the Tahoe mission with the right institutional structure.
* Similar cases:
    * The [Veillid Foundation](https://veilid.org/about-us/) is a very close analog.
    * https://www.djangoproject.com/foundation/
    * https://foundation.mozilla.org/en/who-we-are/
    * https://www.abetterinternet.org/documents/2023-ISRG-Annual-Report.pdf
    * https://www.abetterinternet.org/about/
    * https://matrix.org/foundation/about/
* Fund some dedicated project support

### Who is the community?
* Board members
* What are the activities?
* Intellectual property portfolio (trademarks, copyrights, patents)?

### Who is NOT the community?
Where has the project stalled and why?
Why do people drop in, get frustrated, and leave?
What are the blockers for adoption and how can we overcome them.

### Tahoe public resources; what could we build next?
* Public test grid ?
* ZCap servers ?

#### Other options for funding services

* https://docs.opencollective.foundation/how-it-works/fees

#### Dependent projects
GridSync (golang) ?
Magic Wormhole ?

#### Dependencies
* Twisted
* Mutables
* Python https://meta.pycqa.org/introduction.html

---

## July 23, 2024

### Attendees

Blaise
hacklschorsch
Meejah
b3n
Chris
ccx


## Highlights:
* Mutables would be a good thing for the Foundation to fund.
* The goal of [GBS](https://gitlab.com/tahoe-lafs/gbs-downloader) is to replace foolscap. Not there yet. (sucks to require a node online)
* Create project for client filesystem

## Agenda

### Previous topics:

Meejah: 
* Trac disk space restored
* Granted admin privs

hacklschorsch:
Mobile LAFS [Wiki page](https://tahoe-lafs.org/trac/tahoe-lafs/wiki/TahoeLAFSMobile) with draft description of Features and Scope.

B3n: 
Next, Trac migration path (DNS, )
Codeberg bug


### New topics:
* B3n: Prepare Trac migration operating instructions (DNS settings, etc)
* B3n: Help Meejah create Trac account (for Blaise).
* Decision: Let's try to make the single mobile code base work (hacklschorsch)
* Deep integration with the OS is not MVP  (hacklschorsch)
* [Gitlab milestones](https://gitlab.com/tahoe-lafs/tahoe-lafs-mobile/-/milestones/7#tab-issues) don't have the OS integration yet.(ccx)
* Create FUSE module for the dev environment (ccx)

## Notes:

Chris: 
* [Porting Tahoe hashlib](https://github.com/crwood/deterministic-keygen/issues/5) to Rust and found an issue:
* To do a restore with user supplied keys, if a directory is already created we get an uncoordinated error. Possible solution is to derive the cap locally.
* Curating a common set of test vectors

#### Restore scenarios
Todo: write up a description, describing permuted scenarios (Meejah, Chris)
(We need better words to describe the operations and events)

Four scenarios:
* Client failed, grid is fine
* Grid loses nodes
* Grid loses partial data
* Grid loses all data


#### Mutables
* Don't do service happiness (ccx's complaint)

Can't detect all the restore scenarios. Sometimes all the shares end up on one server :frowning: 
What is the meaning of Happiness? Happiness is just a number (Meejah)

#### Mobile
* Need to write up the description in  [Wiki page](https://tahoe-lafs.org/trac/tahoe-lafs/wiki/TahoeLAFSMobile) 
* We need to describe how much of the functionality
* Foolscap requires a node online, [GBS](https://gitlab.com/tahoe-lafs/gbs-downloader) does not
* "User defined grid" ? (ccx)
* What if we had a gridsync client (b3n)
* Deep integration with the OS is not MVP  (hacklschorsch)
* Obsidian has something called `backend` which is different.
* [Obelisk overrides](https://gitlab.com/tahoe-lafs/tahoe-lafs-mobile/-/blob/main/obelisk/haskell-overrides.nix?ref_type=heads)
* Let's have good interface definitions (ccx)
* [Gitlab repo](https://gitlab.com/tahoe-lafs/tahoe-great-black-swamp) Code 


#### File system browser? (ccx)
* Can we use the native [mobile libraries](https://emanual.github.io/Android-docs/guide/topics/providers/document-provider.html)?
* How much do we need in the GUI?
* (https://gitlab.com/tahoe-lafs/tahoe-lafs-mobile/-/blob/main/obelisk/haskell-overrides.nix?ref_type=heads)

#### Create project: Investigate FUSE File System Support (ccx)
* Read/Only native client
* Read/Only magic folder
* Read/Write Magic Folder
* Built on top of GBS downloader

---



