#!/usr/bin/python
import os
import unittest

from allmydata.client import Client, MULTI_INTRODUCERS_CFG
from allmydata.scripts.create_node import write_node_config

class TestClient(unittest.TestCase):
    
    def test_read_introducer_furl_from_tahoecfg(self):
        """ Ensure that the Client reads the introducer.furl config item from
        the tahoe.cfg file. """
        c = open(os.path.join("tahoe.cfg"), "w")
        config = {}
        write_node_config(c, config)
        fake_furl = "furl1"
        c.write("[client]\n")
        c.write("introducer.furl = %s\n" % fake_furl)        
        c.close()

        # get a client and first introducer_furl
        myclient = Client()        
        tahoe_cfg_furl = myclient.introducer_furls[0]
        # "introducers" file contains introducer_furl from tahoe.cfg                
        furl = open(MULTI_INTRODUCERS_CFG).readline().rstrip()
        #print "got furl: %s" %furl

        self.failUnlessEqual(fake_furl, tahoe_cfg_furl)

if __name__ == "__main__":
    unittest.main()
