#!/usr/bin/python
import os, sys 
import unittest
from mock import Mock, patch, sentinel

from allmydata.introducer.client import IntroducerClient
from allmydata.client import Client, MULTI_INTRODUCERS_CFG
from allmydata.scripts.create_node import write_node_config

class TestClient(unittest.TestCase):
    
    def test_introducer_clients_count(self):
        # create tahoe.cfg with a fake introducer_furl
        basedir = "./"        
        c = open(os.path.join(basedir, "tahoe.cfg"), "w")
        config = {}
        write_node_config(c, config)
        fake_furl = "furl1"
        c.write("[client]\n")
        c.write("introducer.furl = %s\n" % fake_furl)        
        c.close()

        # get a client and first introducer_furl
        myclient = Client()        
        tahoe_cfg_furl = myclient.introducer_furls[0]
        # "introducers" file contains introducer_furl from tahoe.cfg                
        furl = open(MULTI_INTRODUCERS_CFG).readline().rstrip()
        #print "got furl: %s" %furl

        self.failUnlessEqual(fake_furl, tahoe_cfg_furl)

if __name__ == "__main__":
    unittest.main()
