#!/usr/bin/python

import unittest
from mock import Mock, patch

from allmydata.web.root import Root
from allmydata.client import Client

class TestRoot(unittest.TestCase):
    
    @patch('allmydata.web.root.Root')
    def test_introducer_furls(self, MockRoot):        
        # items needed to call data_introducer_furl()
        mockctx = Mock()
        mockdata = Mock()  
        myclient = Client() 
        furls = myclient.introducer_furls
        furl_count = len(furls)    
        #print "furls: %d" %furl_count    
        # Pass mock value to Root
        myroot = Root(myclient)
        
        # make the call
        s = myroot.data_introducers(mockctx, mockdata)
        
        #assertions: compare return value with preset value
        self.failUnlessEqual(furl_count, len(s))  

if __name__ == "__main__":
    unittest.main()
